<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* /home/tiketxplorer/public_html/main_tiketxplorer/themes/balitiket/pages/dashboard/list-booking.htm */
class __TwigTemplate_6df421763f42487f68db3519ab3f18df extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
        $this->sandbox = $this->env->getExtension('\Twig\Extension\SandboxExtension');
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<!-- Content -->

<div class=\"container-xxl flex-grow-1 container-p-y\">
  <div class=\"row\">

    <!-- revenue -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-body\">
          <form action=\"";
        // line 10
        echo url("booking");
        echo "\" method=\"GET\" enctype=\"multipart/form-data\">

            <div class=\"row g-0\">
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label for=\"name\" class=\"form-label\">Guest Name</label>
                <input type=\"text\" class=\"form-control\" id=\"name\" value=\"";
        // line 15
        (((($context["name"] ?? null) != null)) ? (print (twig_escape_filter($this->env, ($context["name"] ?? null), "html", null, true))) : (print ("")));
        echo "\" placeholder=\"name\" name=\"name\" />
              </div>
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label class=\"form-label\" for=\"type\">Date Type</label>
                <select class=\"select2\" name=\"type\" id=\"type\">
                  <option label=\" \" selected disabled></option>
                  <option value=\"Arrival Date\" ";
        // line 21
        echo (((($context["type"] ?? null) == "Arrival Date")) ? ("selected") : (""));
        echo ">Arrival Date</option>
                  <option value=\"Booking Date\" ";
        // line 22
        echo (((($context["type"] ?? null) == "Booking Date")) ? ("selected") : (""));
        echo ">Booking Date</option>
                </select>
              </div>
              <div class=\"col-md-2 col-sm-6 mb-2 px-2\">
                <label for=\"flatpickr-date-1\" class=\"form-label\">From</label>
                <input type=\"text\" class=\"form-control\" id=\"flatpickr-date-1\" value=\"";
        // line 27
        (((($context["from"] ?? null) != null)) ? (print (twig_escape_filter($this->env, ($context["from"] ?? null), "html", null, true))) : (print ("")));
        echo "\" placeholder=\"yyyy-mm-dd\" name=\"from\" />
              </div>
              <div class=\"col-md-2 col-sm-6 mb-2 px-2\">
                <label for=\"flatpickr-date-2\" class=\"form-label\">To</label>
                <input type=\"text\" class=\"form-control\" id=\"flatpickr-date-2\" value=\"";
        // line 31
        (((($context["to"] ?? null) != null)) ? (print (twig_escape_filter($this->env, ($context["to"] ?? null), "html", null, true))) : (print ("")));
        echo "\" placeholder=\"yyyy-mm-dd\" name=\"to\" />
              </div>
              <div class=\"col-md-2 col-sm-6 mb-2 px-2\">
                <label class=\"form-label\">&ensp;</label>
                <button type=\"button\" id=\"show-filter\" class=\"btn btn-secondary w-100 py-2\">Advanced Filter</button>
                <button type=\"button\" id=\"hide-filter\" class=\"btn btn-secondary w-100 py-2 d-none\">Hide Filter</button>
              </div>
            </div>
            <div class=\"row g-0 d-none\" id=\"advanced-filter-container\">
              <hr class=\"my-2\" />
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label for=\"no_invoice\" class=\"form-label\">No. Invoice</label>
                <input type=\"text\" class=\"form-control\" id=\"no_invoice\" value=\"";
        // line 43
        (((($context["no_invoice"] ?? null) != null)) ? (print (twig_escape_filter($this->env, ($context["no_invoice"] ?? null), "html", null, true))) : (print ("")));
        echo "\" placeholder=\"No. Invoice\" name=\"no_invoice\" />
              </div>
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label class=\"form-label\" for=\"status\">Status Payment</label>
                <select class=\"select2\" name=\"status\" id=\"status\">
                  <option label=\" \" selected disabled></option>
                  <option value=\"paid\" ";
        // line 49
        echo (((($context["status"] ?? null) == "paid")) ? ("selected") : (""));
        echo ">Paid</option>
                  <option value=\"pending\" ";
        // line 50
        echo (((($context["status"] ?? null) == "pending")) ? ("selected") : (""));
        echo ">Pending</option>
                  <option value=\"expired\" ";
        // line 51
        echo (((($context["status"] ?? null) == "expired")) ? ("selected") : (""));
        echo ">Expired</option>
                </select>
              </div>
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label class=\"form-label\" for=\"product\">Product</label>
                <select class=\"select2 fs-tiny\" name=\"product\" id=\"product\">
                  <option label=\" \" disabled selected></option>
                  ";
        // line 58
        $context['_parent'] = $context;
        $context['_seq'] = twig_ensure_traversable(($context["products"] ?? null));
        foreach ($context['_seq'] as $context["_key"] => $context["list"]) {
            // line 59
            echo "                  <option value=\"";
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["list"], "id", [], "any", false, false, true, 59), 59, $this->source), "html", null, true);
            echo "\" ";
            echo (((($context["product"] ?? null) == twig_get_attribute($this->env, $this->source, $context["list"], "id", [], "any", false, false, true, 59))) ? ("selected") : (""));
            echo ">";
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["list"], "name", [], "any", false, false, true, 59), 59, $this->source), "html", null, true);
            echo "</option>
                  ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_iterated'], $context['_key'], $context['list'], $context['_parent'], $context['loop']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 61
        echo "                </select>
              </div>
            </div>
            <div class=\"row g-0\">
              <div class=\"col-md-12 col-sm-12 mt-2 px-2\">
                <button type=\"submit\" class=\"btn btn-primary rounded-2 px-5 py-2\">Search</button>
                <a href=\"";
        // line 67
        echo url("booking");
        echo "\" class=\"btn btn-warning rounded-2 px-5 py-2 ms-2\">Reset</a>
              </div>
            </div>

          </form>
        </div>
      </div>
    </div>
    <!-- end revenue -->

    <!-- recent bookings -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">List Bookings</h5>
          <div class=\"text-end w-100 mt-2\">
            <!-- Icon Dropdown -->
            <div class=\"btn-group\">
              <button type=\"button\" class=\"btn btn-primary rounded-3 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
                <i class=\"ti ti-printer me-2\"></i> Export
              </button>
              <ul class=\"dropdown-menu\">
                <li>
                  <!-- export to pdf -->
                  <form action=\"";
        // line 91
        echo url("bali_tiket/export-booking-pdf.php");
        echo "\" target=\"_blank\" method=\"GET\" enctype=\"multipart/form-data\">
                    <input type=\"hidden\" name=\"name\" value=\"";
        // line 92
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["name"] ?? null), 92, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"type\" value=\"";
        // line 93
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["type"] ?? null), 93, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"from\" value=\"";
        // line 94
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["from"] ?? null), 94, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"to\" value=\"";
        // line 95
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["to"] ?? null), 95, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"no_invoice\" value=\"";
        // line 96
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["no_invoice"] ?? null), 96, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"status\" value=\"";
        // line 97
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["status"] ?? null), 97, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"product\" value=\"";
        // line 98
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["product"] ?? null), 98, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"vendor\" value=\"";
        // line 99
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["vendor"] ?? null), 99, $this->source), "html", null, true);
        echo "\">

                    <button class=\"dropdown-item\" type=\"submit\"><i class=\"fa fa-file-pdf me-2\"></i> PDF</button>
                  </form>
                  <!-- end export to pdf -->
                </li>
                <li>
                  <!-- export to excel -->
                  <form action=\"";
        // line 107
        echo url("bali_tiket/export-booking-excel.php");
        echo "\" target=\"_blank\" method=\"GET\" enctype=\"multipart/form-data\">
                    <input type=\"hidden\" name=\"name\" value=\"";
        // line 108
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["name"] ?? null), 108, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"type\" value=\"";
        // line 109
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["type"] ?? null), 109, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"from\" value=\"";
        // line 110
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["from"] ?? null), 110, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"to\" value=\"";
        // line 111
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["to"] ?? null), 111, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"no_invoice\" value=\"";
        // line 112
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["no_invoice"] ?? null), 112, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"status\" value=\"";
        // line 113
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["status"] ?? null), 113, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"product\" value=\"";
        // line 114
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["product"] ?? null), 114, $this->source), "html", null, true);
        echo "\">
                    <input type=\"hidden\" name=\"vendor\" value=\"";
        // line 115
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["vendor"] ?? null), 115, $this->source), "html", null, true);
        echo "\">

                    <button class=\"dropdown-item\" type=\"submit\"><i class=\"fa fa-file-excel me-2\"></i> Excel</button>
                  </form>
                  <!-- end export to excel -->
                </li>
              </ul>
            </div>
          </div>
        </div>
        <div class=\"card-body\">
          <div class=\"card-datatable table-responsive\">
            <table class=\"table border-top\" id=\"recent-booking-list\">
              <thead>
                <tr class=\"\" >
                  <th class=\"fw-bold\">No. Invoice</th>
                  <th class=\"fw-bold\">Booking Date</th>
                  <th class=\"fw-bold\">Name</th>
                  <th class=\"fw-bold\">Arrival Date</th>
                  <th class=\"fw-bold\">Ticket</th>
                  <th class=\"fw-bold\">Amount</th>
                  <th class=\"fw-bold\">Status</th>
                  <th class=\"fw-bold\"></th>
                </tr>
              </thead>
              <tbody>
                ";
        // line 141
        $context['_parent'] = $context;
        $context['_seq'] = twig_ensure_traversable(($context["bookings"] ?? null));
        foreach ($context['_seq'] as $context["key"] => $context["booking"]) {
            // line 142
            echo "                <tr>
                  <td><small>";
            // line 143
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "no_invoice", [], "any", false, false, true, 143), 143, $this->source), "html", null, true);
            echo "</small></td>
                  <td><small>";
            // line 144
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "invoice_date", [], "any", false, false, true, 144), 144, $this->source), "html", null, true);
            echo "</small></td>
                  <td><small>";
            // line 145
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "firstname", [], "any", false, false, true, 145), 145, $this->source), "html", null, true);
            echo "</small></td>
                  <td><small>";
            // line 146
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "arrival_date", [], "any", false, false, true, 146), 146, $this->source), "html", null, true);
            echo "</small></td>
                  <td><small>";
            // line 147
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "ticketName", [twig_get_attribute($this->env, $this->source, $context["booking"], "ticket_id", [], "any", false, false, true, 147)], "method", false, false, true, 147), 147, $this->source), "html", null, true);
            echo "</small></td>
                  <td><small>IDR ";
            // line 148
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "priceFormat", [twig_get_attribute($this->env, $this->source, $context["booking"], "total_price", [], "any", false, false, true, 148)], "method", false, false, true, 148), 148, $this->source), "html", null, true);
            echo "</small></td>
                  <td>
                    ";
            // line 150
            if ((twig_get_attribute($this->env, $this->source, $context["booking"], "status_payment", [], "any", false, false, true, 150) == "pending")) {
                // line 151
                echo "                    <span class=\"badge bg-warning\">pending</span>
                    ";
            } elseif ((twig_get_attribute($this->env, $this->source,             // line 152
$context["booking"], "status_payment", [], "any", false, false, true, 152) == "paid")) {
                // line 153
                echo "                    <span class=\"badge bg-success\">paid</span>
                    ";
            } elseif ((twig_get_attribute($this->env, $this->source,             // line 154
$context["booking"], "status_payment", [], "any", false, false, true, 154) == "expired")) {
                // line 155
                echo "                    <span class=\"badge bg-danger\">expired</span>
                    ";
            }
            // line 157
            echo "                  </td>
                  <td class=\"text-end\">
                    <div class=\"d-flex flex-row\">
                      ";
            // line 160
            if (((twig_get_attribute($this->env, $this->source, $context["booking"], "voucher_link", [], "any", false, false, true, 160) != null) && (twig_get_attribute($this->env, $this->source, $context["booking"], "status_payment", [], "any", false, false, true, 160) == "paid"))) {
                // line 161
                echo "                      <a class=\"btn btn-primary btn-xs px-2 m-1\" href=\"https://main.tiketxplorer.com/bali_tiket/";
                echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "voucher_link", [], "any", false, false, true, 161), 161, $this->source), "html", null, true);
                echo "\" target=\"_blank\"><i class=\"fa fa-eye align-middle\"></i></a>
                      ";
            }
            // line 163
            echo "                      <!-- <a class=\"btn btn-warning btn-xs px-2 m-1\" href=\"";
            echo url((("booking/" . $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, true, 163), 163, $this->source)) . "/edit/1"));
            echo "\"><i class=\"fa fa-edit align-middle\"></i></a> -->

                      <button class=\"btn btn-danger btn-xs px-2 m-1\" data-bs-toggle=\"modal\" data-bs-target=\"#delete-booking-";
            // line 165
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed($context["key"], 165, $this->source), "html", null, true);
            echo "\"><i class=\"fa fa-trash align-middle\"></i></button>
                    </div>

                    <div class=\"modal fade\" id=\"delete-booking-";
            // line 168
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed($context["key"], 168, $this->source), "html", null, true);
            echo "\" tabindex=\"-1\" aria-labelledby=\"exampleModalLabel\" aria-hidden=\"true\">
                      <div class=\"modal-dialog modal-sm modal-dialog-centered\" role=\"document\">
                        <div class=\"modal-content\">
                          <div class=\"modal-body text-start\">
                            <p class=\"fs-big\">Are you sure you want to delete this <b>";
            // line 172
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "no_invoice", [], "any", false, false, true, 172), 172, $this->source), "html", null, true);
            echo "</b> ?</p>
                          </div>
                          <div class=\"modal-footer justify-content-between\">
                            <button type=\"button\" class=\"btn btn-secondary\" data-bs-dismiss=\"modal\">Cancel</button>
                            <form data-request=\"onDelete\" method=\"POST\">
                              <input type=\"hidden\" name=\"id_booking\" value=\"";
            // line 177
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "id", [], "any", false, false, true, 177), 177, $this->source), "html", null, true);
            echo "\">
                              <button type=\"submit\" class=\"btn btn-danger\" data-bs-dismiss=\"modal\">Delete</button>
                            </form>
                          </div>
                        </div>
                      </div>
                    </div>

                  </td>
                </tr>
                ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_iterated'], $context['key'], $context['booking'], $context['_parent'], $context['loop']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 188
        echo "              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <!-- end recent bookings -->

    <!-- revenue -->
    <div class=\"col-6 col-xl-4 col-sm-6 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Total Revenue</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"d-flex gap-2 align-items-center\">
            <div class=\"badge rounded bg-label-success p-1\"><i class=\"ti ti-currency-dollar ti-sm\"></i></div>
            <h4 class=\"mb-0\">IDR ";
        // line 205
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(($context["totalRevenue"] ?? null), 205, $this->source), "html", null, true);
        echo "</h4>
          </div>
        </div>
      </div>
    </div>
    <!-- end revenue -->

    <!-- lead time statistic -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Lead Time Bookings</h5>
        </div>
        <div class=\"card-body\">
          <canvas id=\"barChart\" class=\"chartjs\" data-height=\"400\"></canvas>
        </div>
      </div>
    </div>
    <!-- end lead time statistic -->

  </div>
</div>
<!-- / Content -->


<!-- js -->
";
        // line 231
        echo $this->env->getExtension('Cms\Twig\Extension')->startBlock('scripts'        );
        // line 232
        echo "
<script type=\"text/javascript\">
  //  For Datatable
  // --------------------------------------------------------------------
  var dt_projects_table = \$('.datatables-projects');

  var dt_project = dt_projects_table.DataTable({

  });

  // select2 option
  \$(function () {
    const select2 = \$('.select2'),
    selectPicker = \$('.selectpicker');

    // Bootstrap select
    if (selectPicker.length) {
      selectPicker.selectpicker();
    }

    // select2
    if (select2.length) {
      select2.each(function () {
        var \$this = \$(this);
        \$this.wrap('<div class=\"position-relative\"></div>');
        \$this.select2({
          placeholder: 'Select value',
          dropdownParent: \$this.parent()
        });
      });
    }
  });

  (function () {
  // Flat Picker
  // --------------------------------------------------------------------
    const flatpickrDate1 = document.querySelector('#flatpickr-date-1'),
    flatpickrDate2 = document.querySelector('#flatpickr-date-2');

  // Initialize Flatpickr on flatpickrDate1
    if (flatpickrDate1) {
      flatpickrDate1.flatpickr({
        enableTime: false,
        dateFormat: 'Y-m-d',
        onChange: function(selectedDates, dateStr, instance) {
        // When a date is selected in flatpickrDate1, update the minDate of flatpickrDate2
          if (flatpickrDate2) {
            flatpickrDate2._flatpickr.set('minDate', dateStr);
          }
        }
      });
    }

  // Initialize Flatpickr on flatpickrDate2
    if (flatpickrDate2) {
      flatpickrDate2.flatpickr({
        enableTime: false,
        dateFormat: 'Y-m-d',
      minDate: flatpickrDate1 ? flatpickrDate1.value : null // Set initial minDate if a date is already selected in flatpickrDate1
    });
    }
  })();

  \$(document).ready(function() {
    // Ketika tombol \"Advanced Filter\" diklik
    \$('#show-filter').on('click', function() {
      \$('#advanced-filter-container').removeClass('d-none'); // Tampilkan kontainer filter lanjutan
      \$(this).addClass('d-none'); // Sembunyikan tombol \"Advanced Filter\"
      \$('#hide-filter').removeClass('d-none'); // Tampilkan tombol \"Hide Filter\"
    });

    // Ketika tombol \"Hide Filter\" diklik
    \$('#hide-filter').on('click', function() {
      \$('#advanced-filter-container').addClass('d-none'); // Sembunyikan kontainer filter lanjutan
      \$(this).addClass('d-none'); // Sembunyikan tombol \"Hide Filter\"
      \$('#show-filter').removeClass('d-none'); // Tampilkan tombol \"Advanced Filter\"
    });
  });


  //lead time booking
  (function () {
    // Color Variables
    const purpleColor = '#836AF9',
    yellowColor = '#ffe800',
    cyanColor = '#28dac6',
    orangeColor = '#FF8132',
    orangeLightColor = '#FDAC34',
    oceanBlueColor = '#299AFF',
    greyColor = '#4F5D70',
    greyLightColor = '#EDF1F4',
    blueColor = '#2B9AFF',
    blueLightColor = '#84D0FF';

    let cardColor, headingColor, labelColor, borderColor, legendColor;

    if (isDarkStyle) {
      cardColor = config.colors_dark.cardColor;
      headingColor = config.colors_dark.headingColor;
      labelColor = config.colors_dark.textMuted;
      legendColor = config.colors_dark.bodyColor;
      borderColor = config.colors_dark.borderColor;
    } else {
      cardColor = config.colors.cardColor;
      headingColor = config.colors.headingColor;
      labelColor = config.colors.textMuted;
      legendColor = config.colors.bodyColor;
      borderColor = config.colors.borderColor;
    }

    // Set height according to their data-height
    const chartList = document.querySelectorAll('.chartjs');
    chartList.forEach(function (chartListItem) {
      chartListItem.height = chartListItem.dataset.height;
    });

    // Prepare data for the chart
    const leadTimeData = ";
        // line 349
        echo $this->sandbox->ensureToStringAllowed(($context["leadtime"] ?? null), 349, $this->source);
        echo ";
    const labels = [];
    const data = [];

    leadTimeData.forEach(item => {
      labels.push(item.lead_time_group);
      data.push(item.total_bookings);
    });

    // Bar Chart
    const barChart = document.getElementById('barChart');
    if (barChart) {
      const barChartVar = new Chart(barChart, {
        type: 'bar',
        data: {
          labels: labels,
          datasets: [
          {
            data: data,
            backgroundColor: cyanColor,
            borderColor: 'transparent',
            maxBarThickness: 50,
            borderRadius: {
              topRight: 0,
              topLeft: 0
            }
          }
          ]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          animation: {
            duration: 500
          },
          plugins: {
            tooltip: {
              rtl: isRtl,
              backgroundColor: cardColor,
              titleColor: headingColor,
              bodyColor: legendColor,
              borderWidth: 1,
              borderColor: borderColor
            },
            legend: {
              display: false
            }
          },
          scales: {
            x: {
              grid: {
                color: borderColor,
                drawBorder: false,
                borderColor: borderColor
              },
              ticks: {
                color: labelColor
              }
            },
            y: {
              min: 0,
              grid: {
                color: borderColor,
                drawBorder: false,
                borderColor: borderColor
              },
              ticks: {
                stepSize: Math.ceil((Math.max(...data) + 20) / 2),
                color: labelColor
              }
            }
          }
        }
      });
    }
  })();
</script>
";
        // line 231
        echo $this->env->getExtension('Cms\Twig\Extension')->endBlock(true        );
        // line 427
        echo "<!-- end js -->";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName()
    {
        return "/home/tiketxplorer/public_html/main_tiketxplorer/themes/balitiket/pages/dashboard/list-booking.htm";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable()
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo()
    {
        return array (  640 => 427,  638 => 231,  558 => 349,  439 => 232,  437 => 231,  408 => 205,  389 => 188,  372 => 177,  364 => 172,  357 => 168,  351 => 165,  345 => 163,  339 => 161,  337 => 160,  332 => 157,  328 => 155,  326 => 154,  323 => 153,  321 => 152,  318 => 151,  316 => 150,  311 => 148,  307 => 147,  303 => 146,  299 => 145,  295 => 144,  291 => 143,  288 => 142,  284 => 141,  255 => 115,  251 => 114,  247 => 113,  243 => 112,  239 => 111,  235 => 110,  231 => 109,  227 => 108,  223 => 107,  212 => 99,  208 => 98,  204 => 97,  200 => 96,  196 => 95,  192 => 94,  188 => 93,  184 => 92,  180 => 91,  153 => 67,  145 => 61,  132 => 59,  128 => 58,  118 => 51,  114 => 50,  110 => 49,  101 => 43,  86 => 31,  79 => 27,  71 => 22,  67 => 21,  58 => 15,  50 => 10,  39 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("<!-- Content -->

<div class=\"container-xxl flex-grow-1 container-p-y\">
  <div class=\"row\">

    <!-- revenue -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-body\">
          <form action=\"{{url('booking')}}\" method=\"GET\" enctype=\"multipart/form-data\">

            <div class=\"row g-0\">
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label for=\"name\" class=\"form-label\">Guest Name</label>
                <input type=\"text\" class=\"form-control\" id=\"name\" value=\"{{ (name != null) ? name : '' }}\" placeholder=\"name\" name=\"name\" />
              </div>
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label class=\"form-label\" for=\"type\">Date Type</label>
                <select class=\"select2\" name=\"type\" id=\"type\">
                  <option label=\" \" selected disabled></option>
                  <option value=\"Arrival Date\" {{ (type == 'Arrival Date') ? 'selected' : '' }}>Arrival Date</option>
                  <option value=\"Booking Date\" {{ (type == 'Booking Date') ? 'selected' : '' }}>Booking Date</option>
                </select>
              </div>
              <div class=\"col-md-2 col-sm-6 mb-2 px-2\">
                <label for=\"flatpickr-date-1\" class=\"form-label\">From</label>
                <input type=\"text\" class=\"form-control\" id=\"flatpickr-date-1\" value=\"{{ (from != null) ? from : '' }}\" placeholder=\"yyyy-mm-dd\" name=\"from\" />
              </div>
              <div class=\"col-md-2 col-sm-6 mb-2 px-2\">
                <label for=\"flatpickr-date-2\" class=\"form-label\">To</label>
                <input type=\"text\" class=\"form-control\" id=\"flatpickr-date-2\" value=\"{{ (to != null) ? to : '' }}\" placeholder=\"yyyy-mm-dd\" name=\"to\" />
              </div>
              <div class=\"col-md-2 col-sm-6 mb-2 px-2\">
                <label class=\"form-label\">&ensp;</label>
                <button type=\"button\" id=\"show-filter\" class=\"btn btn-secondary w-100 py-2\">Advanced Filter</button>
                <button type=\"button\" id=\"hide-filter\" class=\"btn btn-secondary w-100 py-2 d-none\">Hide Filter</button>
              </div>
            </div>
            <div class=\"row g-0 d-none\" id=\"advanced-filter-container\">
              <hr class=\"my-2\" />
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label for=\"no_invoice\" class=\"form-label\">No. Invoice</label>
                <input type=\"text\" class=\"form-control\" id=\"no_invoice\" value=\"{{ (no_invoice != null) ? no_invoice : '' }}\" placeholder=\"No. Invoice\" name=\"no_invoice\" />
              </div>
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label class=\"form-label\" for=\"status\">Status Payment</label>
                <select class=\"select2\" name=\"status\" id=\"status\">
                  <option label=\" \" selected disabled></option>
                  <option value=\"paid\" {{ (status == 'paid') ? 'selected' : '' }}>Paid</option>
                  <option value=\"pending\" {{ (status == 'pending') ? 'selected' : '' }}>Pending</option>
                  <option value=\"expired\" {{ (status == 'expired') ? 'selected' : '' }}>Expired</option>
                </select>
              </div>
              <div class=\"col-md-3 col-sm-6 mb-2 px-2\">
                <label class=\"form-label\" for=\"product\">Product</label>
                <select class=\"select2 fs-tiny\" name=\"product\" id=\"product\">
                  <option label=\" \" disabled selected></option>
                  {% for list in products %}
                  <option value=\"{{list.id}}\" {{ (product == list.id) ? 'selected' : '' }}>{{list.name}}</option>
                  {% endfor %}
                </select>
              </div>
            </div>
            <div class=\"row g-0\">
              <div class=\"col-md-12 col-sm-12 mt-2 px-2\">
                <button type=\"submit\" class=\"btn btn-primary rounded-2 px-5 py-2\">Search</button>
                <a href=\"{{url('booking')}}\" class=\"btn btn-warning rounded-2 px-5 py-2 ms-2\">Reset</a>
              </div>
            </div>

          </form>
        </div>
      </div>
    </div>
    <!-- end revenue -->

    <!-- recent bookings -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">List Bookings</h5>
          <div class=\"text-end w-100 mt-2\">
            <!-- Icon Dropdown -->
            <div class=\"btn-group\">
              <button type=\"button\" class=\"btn btn-primary rounded-3 dropdown-toggle hide-arrow\" data-bs-toggle=\"dropdown\">
                <i class=\"ti ti-printer me-2\"></i> Export
              </button>
              <ul class=\"dropdown-menu\">
                <li>
                  <!-- export to pdf -->
                  <form action=\"{{url('bali_tiket/export-booking-pdf.php')}}\" target=\"_blank\" method=\"GET\" enctype=\"multipart/form-data\">
                    <input type=\"hidden\" name=\"name\" value=\"{{ name }}\">
                    <input type=\"hidden\" name=\"type\" value=\"{{ type }}\">
                    <input type=\"hidden\" name=\"from\" value=\"{{ from }}\">
                    <input type=\"hidden\" name=\"to\" value=\"{{ to }}\">
                    <input type=\"hidden\" name=\"no_invoice\" value=\"{{ no_invoice }}\">
                    <input type=\"hidden\" name=\"status\" value=\"{{ status }}\">
                    <input type=\"hidden\" name=\"product\" value=\"{{ product }}\">
                    <input type=\"hidden\" name=\"vendor\" value=\"{{ vendor }}\">

                    <button class=\"dropdown-item\" type=\"submit\"><i class=\"fa fa-file-pdf me-2\"></i> PDF</button>
                  </form>
                  <!-- end export to pdf -->
                </li>
                <li>
                  <!-- export to excel -->
                  <form action=\"{{url('bali_tiket/export-booking-excel.php')}}\" target=\"_blank\" method=\"GET\" enctype=\"multipart/form-data\">
                    <input type=\"hidden\" name=\"name\" value=\"{{ name }}\">
                    <input type=\"hidden\" name=\"type\" value=\"{{ type }}\">
                    <input type=\"hidden\" name=\"from\" value=\"{{ from }}\">
                    <input type=\"hidden\" name=\"to\" value=\"{{ to }}\">
                    <input type=\"hidden\" name=\"no_invoice\" value=\"{{ no_invoice }}\">
                    <input type=\"hidden\" name=\"status\" value=\"{{ status }}\">
                    <input type=\"hidden\" name=\"product\" value=\"{{ product }}\">
                    <input type=\"hidden\" name=\"vendor\" value=\"{{ vendor }}\">

                    <button class=\"dropdown-item\" type=\"submit\"><i class=\"fa fa-file-excel me-2\"></i> Excel</button>
                  </form>
                  <!-- end export to excel -->
                </li>
              </ul>
            </div>
          </div>
        </div>
        <div class=\"card-body\">
          <div class=\"card-datatable table-responsive\">
            <table class=\"table border-top\" id=\"recent-booking-list\">
              <thead>
                <tr class=\"\" >
                  <th class=\"fw-bold\">No. Invoice</th>
                  <th class=\"fw-bold\">Booking Date</th>
                  <th class=\"fw-bold\">Name</th>
                  <th class=\"fw-bold\">Arrival Date</th>
                  <th class=\"fw-bold\">Ticket</th>
                  <th class=\"fw-bold\">Amount</th>
                  <th class=\"fw-bold\">Status</th>
                  <th class=\"fw-bold\"></th>
                </tr>
              </thead>
              <tbody>
                {% for key, booking in bookings %}
                <tr>
                  <td><small>{{ booking.no_invoice }}</small></td>
                  <td><small>{{ booking.invoice_date }}</small></td>
                  <td><small>{{ booking.firstname }}</small></td>
                  <td><small>{{ booking.arrival_date }}</small></td>
                  <td><small>{{ booking.ticketName(booking.ticket_id) }}</small></td>
                  <td><small>IDR {{ booking.priceFormat(booking.total_price) }}</small></td>
                  <td>
                    {% if booking.status_payment == 'pending' %}
                    <span class=\"badge bg-warning\">pending</span>
                    {% elseif booking.status_payment == 'paid' %}
                    <span class=\"badge bg-success\">paid</span>
                    {% elseif booking.status_payment == 'expired' %}
                    <span class=\"badge bg-danger\">expired</span>
                    {% endif %}
                  </td>
                  <td class=\"text-end\">
                    <div class=\"d-flex flex-row\">
                      {% if booking.voucher_link != null and booking.status_payment == 'paid' %}
                      <a class=\"btn btn-primary btn-xs px-2 m-1\" href=\"https://main.tiketxplorer.com/bali_tiket/{{booking.voucher_link}}\" target=\"_blank\"><i class=\"fa fa-eye align-middle\"></i></a>
                      {% endif %}
                      <!-- <a class=\"btn btn-warning btn-xs px-2 m-1\" href=\"{{url('booking/'~booking.id~'/edit/1')}}\"><i class=\"fa fa-edit align-middle\"></i></a> -->

                      <button class=\"btn btn-danger btn-xs px-2 m-1\" data-bs-toggle=\"modal\" data-bs-target=\"#delete-booking-{{key}}\"><i class=\"fa fa-trash align-middle\"></i></button>
                    </div>

                    <div class=\"modal fade\" id=\"delete-booking-{{key}}\" tabindex=\"-1\" aria-labelledby=\"exampleModalLabel\" aria-hidden=\"true\">
                      <div class=\"modal-dialog modal-sm modal-dialog-centered\" role=\"document\">
                        <div class=\"modal-content\">
                          <div class=\"modal-body text-start\">
                            <p class=\"fs-big\">Are you sure you want to delete this <b>{{ booking.no_invoice }}</b> ?</p>
                          </div>
                          <div class=\"modal-footer justify-content-between\">
                            <button type=\"button\" class=\"btn btn-secondary\" data-bs-dismiss=\"modal\">Cancel</button>
                            <form data-request=\"onDelete\" method=\"POST\">
                              <input type=\"hidden\" name=\"id_booking\" value=\"{{booking.id}}\">
                              <button type=\"submit\" class=\"btn btn-danger\" data-bs-dismiss=\"modal\">Delete</button>
                            </form>
                          </div>
                        </div>
                      </div>
                    </div>

                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <!-- end recent bookings -->

    <!-- revenue -->
    <div class=\"col-6 col-xl-4 col-sm-6 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Total Revenue</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"d-flex gap-2 align-items-center\">
            <div class=\"badge rounded bg-label-success p-1\"><i class=\"ti ti-currency-dollar ti-sm\"></i></div>
            <h4 class=\"mb-0\">IDR {{totalRevenue}}</h4>
          </div>
        </div>
      </div>
    </div>
    <!-- end revenue -->

    <!-- lead time statistic -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Lead Time Bookings</h5>
        </div>
        <div class=\"card-body\">
          <canvas id=\"barChart\" class=\"chartjs\" data-height=\"400\"></canvas>
        </div>
      </div>
    </div>
    <!-- end lead time statistic -->

  </div>
</div>
<!-- / Content -->


<!-- js -->
{% put scripts %}

<script type=\"text/javascript\">
  //  For Datatable
  // --------------------------------------------------------------------
  var dt_projects_table = \$('.datatables-projects');

  var dt_project = dt_projects_table.DataTable({

  });

  // select2 option
  \$(function () {
    const select2 = \$('.select2'),
    selectPicker = \$('.selectpicker');

    // Bootstrap select
    if (selectPicker.length) {
      selectPicker.selectpicker();
    }

    // select2
    if (select2.length) {
      select2.each(function () {
        var \$this = \$(this);
        \$this.wrap('<div class=\"position-relative\"></div>');
        \$this.select2({
          placeholder: 'Select value',
          dropdownParent: \$this.parent()
        });
      });
    }
  });

  (function () {
  // Flat Picker
  // --------------------------------------------------------------------
    const flatpickrDate1 = document.querySelector('#flatpickr-date-1'),
    flatpickrDate2 = document.querySelector('#flatpickr-date-2');

  // Initialize Flatpickr on flatpickrDate1
    if (flatpickrDate1) {
      flatpickrDate1.flatpickr({
        enableTime: false,
        dateFormat: 'Y-m-d',
        onChange: function(selectedDates, dateStr, instance) {
        // When a date is selected in flatpickrDate1, update the minDate of flatpickrDate2
          if (flatpickrDate2) {
            flatpickrDate2._flatpickr.set('minDate', dateStr);
          }
        }
      });
    }

  // Initialize Flatpickr on flatpickrDate2
    if (flatpickrDate2) {
      flatpickrDate2.flatpickr({
        enableTime: false,
        dateFormat: 'Y-m-d',
      minDate: flatpickrDate1 ? flatpickrDate1.value : null // Set initial minDate if a date is already selected in flatpickrDate1
    });
    }
  })();

  \$(document).ready(function() {
    // Ketika tombol \"Advanced Filter\" diklik
    \$('#show-filter').on('click', function() {
      \$('#advanced-filter-container').removeClass('d-none'); // Tampilkan kontainer filter lanjutan
      \$(this).addClass('d-none'); // Sembunyikan tombol \"Advanced Filter\"
      \$('#hide-filter').removeClass('d-none'); // Tampilkan tombol \"Hide Filter\"
    });

    // Ketika tombol \"Hide Filter\" diklik
    \$('#hide-filter').on('click', function() {
      \$('#advanced-filter-container').addClass('d-none'); // Sembunyikan kontainer filter lanjutan
      \$(this).addClass('d-none'); // Sembunyikan tombol \"Hide Filter\"
      \$('#show-filter').removeClass('d-none'); // Tampilkan tombol \"Advanced Filter\"
    });
  });


  //lead time booking
  (function () {
    // Color Variables
    const purpleColor = '#836AF9',
    yellowColor = '#ffe800',
    cyanColor = '#28dac6',
    orangeColor = '#FF8132',
    orangeLightColor = '#FDAC34',
    oceanBlueColor = '#299AFF',
    greyColor = '#4F5D70',
    greyLightColor = '#EDF1F4',
    blueColor = '#2B9AFF',
    blueLightColor = '#84D0FF';

    let cardColor, headingColor, labelColor, borderColor, legendColor;

    if (isDarkStyle) {
      cardColor = config.colors_dark.cardColor;
      headingColor = config.colors_dark.headingColor;
      labelColor = config.colors_dark.textMuted;
      legendColor = config.colors_dark.bodyColor;
      borderColor = config.colors_dark.borderColor;
    } else {
      cardColor = config.colors.cardColor;
      headingColor = config.colors.headingColor;
      labelColor = config.colors.textMuted;
      legendColor = config.colors.bodyColor;
      borderColor = config.colors.borderColor;
    }

    // Set height according to their data-height
    const chartList = document.querySelectorAll('.chartjs');
    chartList.forEach(function (chartListItem) {
      chartListItem.height = chartListItem.dataset.height;
    });

    // Prepare data for the chart
    const leadTimeData = {{ leadtime | raw }};
    const labels = [];
    const data = [];

    leadTimeData.forEach(item => {
      labels.push(item.lead_time_group);
      data.push(item.total_bookings);
    });

    // Bar Chart
    const barChart = document.getElementById('barChart');
    if (barChart) {
      const barChartVar = new Chart(barChart, {
        type: 'bar',
        data: {
          labels: labels,
          datasets: [
          {
            data: data,
            backgroundColor: cyanColor,
            borderColor: 'transparent',
            maxBarThickness: 50,
            borderRadius: {
              topRight: 0,
              topLeft: 0
            }
          }
          ]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          animation: {
            duration: 500
          },
          plugins: {
            tooltip: {
              rtl: isRtl,
              backgroundColor: cardColor,
              titleColor: headingColor,
              bodyColor: legendColor,
              borderWidth: 1,
              borderColor: borderColor
            },
            legend: {
              display: false
            }
          },
          scales: {
            x: {
              grid: {
                color: borderColor,
                drawBorder: false,
                borderColor: borderColor
              },
              ticks: {
                color: labelColor
              }
            },
            y: {
              min: 0,
              grid: {
                color: borderColor,
                drawBorder: false,
                borderColor: borderColor
              },
              ticks: {
                stepSize: Math.ceil((Math.max(...data) + 20) / 2),
                color: labelColor
              }
            }
          }
        }
      });
    }
  })();
</script>
{% endput %}
<!-- end js -->", "/home/tiketxplorer/public_html/main_tiketxplorer/themes/balitiket/pages/dashboard/list-booking.htm", "");
    }
    
    public function checkSecurity()
    {
        static $tags = array("for" => 58, "if" => 150, "put" => 231);
        static $filters = array("escape" => 15, "raw" => 349);
        static $functions = array("url" => 10);

        try {
            $this->sandbox->checkSecurity(
                ['for', 'if', 'put'],
                ['escape', 'raw'],
                ['url']
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
