<?php

use Twig\Environment;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Extension\SandboxExtension;
use Twig\Markup;
use Twig\Sandbox\SecurityError;
use Twig\Sandbox\SecurityNotAllowedTagError;
use Twig\Sandbox\SecurityNotAllowedFilterError;
use Twig\Sandbox\SecurityNotAllowedFunctionError;
use Twig\Source;
use Twig\Template;

/* /home/tiketxplorer/public_html/main_tiketxplorer/themes/balitiket/pages/dashboard/dashboard.htm */
class __TwigTemplate_92e3f767c1d87cf9de8fcf9059366362 extends Template
{
    private $source;
    private $macros = [];

    public function __construct(Environment $env)
    {
        parent::__construct($env);

        $this->source = $this->getSourceContext();

        $this->parent = false;

        $this->blocks = [
        ];
        $this->sandbox = $this->env->getExtension('\Twig\Extension\SandboxExtension');
        $this->checkSecurity();
    }

    protected function doDisplay(array $context, array $blocks = [])
    {
        $macros = $this->macros;
        // line 1
        echo "<!-- Content -->

<div class=\"container-xxl flex-grow-1 container-p-y\">
  <div class=\"row\">

    <!-- revenue -->
    <div class=\"col-6 col-xl-4 col-sm-6 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Last 30 Days Revenue</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"d-flex gap-2 align-items-center\">
            <div class=\"badge rounded bg-label-info p-1\"><i class=\"ti ti-chart-pie-2 ti-sm\"></i></div>
            <h4 class=\"mb-0\">";
        // line 15
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, ($context["booking"] ?? null), "revenueThirtyDays", [($context["vendor"] ?? null)], "method", false, false, true, 15), 15, $this->source), "html", null, true);
        echo " IDR</h4>
          </div>
        </div>
      </div>
    </div>

    <div class=\"col-6 col-xl-4 col-sm-6 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Today's Revenue</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"d-flex gap-2 align-items-center\">
            <div class=\"badge rounded bg-label-primary p-1\">
              <i class=\"ti ti-currency-dollar ti-sm\"></i>
            </div>
            <h4 class=\"mb-0\">";
        // line 31
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, ($context["booking"] ?? null), "revenueToday", [($context["vendor"] ?? null)], "method", false, false, true, 31), 31, $this->source), "html", null, true);
        echo " IDR</h4>
          </div>
        </div>
      </div>
    </div>

    <div class=\"col-6 col-xl-4 col-sm-6 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Last 30 Days Tickets Sold</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"d-flex gap-2 align-items-center\">
            <div class=\"badge rounded bg-label-warning p-1\">
              <i class=\"ti ti-ticket ti-sm\"></i>
            </div>
            <h4 class=\"mb-0\">";
        // line 47
        echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, ($context["booking"] ?? null), "saleThirtyDays", [($context["vendor"] ?? null)], "method", false, false, true, 47), 47, $this->source), "html", null, true);
        echo " Tickets</h4>
          </div>
        </div>
      </div>
    </div>
    <!-- end revenue -->

    <!-- recent bookings -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Recent Bookings</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"card-datatable table-responsive\">
            <table class=\"table border-top\" id=\"recent-booking-list\">
              <thead>
                <tr class=\"\" >
                  <th class=\"fw-bold\">No. Invoice</th>
                  <th class=\"fw-bold\">Booking Date</th>
                  <th class=\"fw-bold\">Name</th>
                  <th class=\"fw-bold\">Arrival Date</th>
                  <th class=\"fw-bold\">Amount</th>
                  <th class=\"fw-bold\">Status Payment</th>
                  <th class=\"fw-bold\"></th>
                </tr>
              </thead>
              <tbody>
                ";
        // line 75
        $context['_parent'] = $context;
        $context['_seq'] = twig_ensure_traversable(($context["bookings"] ?? null));
        foreach ($context['_seq'] as $context["_key"] => $context["booking"]) {
            // line 76
            echo "                <tr>
                  <td>";
            // line 77
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "no_invoice", [], "any", false, false, true, 77), 77, $this->source), "html", null, true);
            echo "</td>
                  <td>";
            // line 78
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "invoice_date", [], "any", false, false, true, 78), 78, $this->source), "html", null, true);
            echo "</td>
                  <td>";
            // line 79
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "firstname", [], "any", false, false, true, 79), 79, $this->source), "html", null, true);
            echo "</td>
                  <td>";
            // line 80
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "arrival_date", [], "any", false, false, true, 80), 80, $this->source), "html", null, true);
            echo "</td>
                  <td>IDR ";
            // line 81
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "priceFormat", [twig_get_attribute($this->env, $this->source, $context["booking"], "total_price", [], "any", false, false, true, 81)], "method", false, false, true, 81), 81, $this->source), "html", null, true);
            echo "</td>
                  <td>
                    ";
            // line 83
            if ((twig_get_attribute($this->env, $this->source, $context["booking"], "status_payment", [], "any", false, false, true, 83) == "pending")) {
                // line 84
                echo "                    <span class=\"badge bg-warning\">pending</span>
                    ";
            } elseif ((twig_get_attribute($this->env, $this->source,             // line 85
$context["booking"], "status_payment", [], "any", false, false, true, 85) == "paid")) {
                // line 86
                echo "                    <span class=\"badge bg-success\">paid</span>
                    ";
            } elseif ((twig_get_attribute($this->env, $this->source,             // line 87
$context["booking"], "status_payment", [], "any", false, false, true, 87) == "expired")) {
                // line 88
                echo "                    <span class=\"badge bg-danger\">expired</span>
                    ";
            }
            // line 90
            echo "                  </td>
                  <td class=\"text-end\">
                    ";
            // line 92
            if (((twig_get_attribute($this->env, $this->source, $context["booking"], "voucher_link", [], "any", false, false, true, 92) != null) && (twig_get_attribute($this->env, $this->source, $context["booking"], "status_payment", [], "any", false, false, true, 92) == "paid"))) {
                // line 93
                echo "                    <a class=\"btn btn-primary btn-sm\" href=\"https://main.tiketxplorer.com/bali_tiket/";
                echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["booking"], "voucher_link", [], "any", false, false, true, 93), 93, $this->source), "html", null, true);
                echo "\" target=\"_blank\"><i class=\"fa fa-eye me-2\"></i>view</a>
                    ";
            }
            // line 95
            echo "                  </td>
                </tr>
                ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_iterated'], $context['_key'], $context['booking'], $context['_parent'], $context['loop']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 98
        echo "              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <!-- end recent bookings -->

    <!-- country -->
    <div class=\"col-md-6 col-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header d-flex align-items-center justify-content-between\">
          <div>
            <h5 class=\"card-title mb-0\">Last 30 Days Revenue by Country</h5>
          </div>
          <div class=\"dropdown d-none d-sm-flex\">
            <h5 class=\"mb-0 me-3\"><small class=\"text-muted\">";
        // line 114
        echo (((($context["from"] ?? null) != null)) ? ($this->env->getFilter('date')->getCallable()($this->env, $this->sandbox->ensureToStringAllowed(($context["from"] ?? null), 114, $this->source), "d F Y")) : (""));
        echo " <span class=\"mx-2\">";
        echo (((($context["to"] ?? null) != null)) ? ("-") : (""));
        echo "</span> ";
        echo (((($context["to"] ?? null) != null)) ? ($this->env->getFilter('date')->getCallable()($this->env, $this->sandbox->ensureToStringAllowed(($context["to"] ?? null), 114, $this->source), "d F Y")) : (""));
        echo "</small></h5>
          </div>
        </div>
        <div class=\"card-body\">
          <div id=\"donutChart\"></div>
        </div>
      </div>
    </div>
    <!-- end country -->

    <!-- country -->
    <div class=\"col-12 col-xl-6 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Best-Selling Tickets in the Last 30 Days</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"card-datatable table-responsive\">
            <table class=\"table border-top\" id=\"recent-booking-list\">
              <thead>
                <tr class=\"\" >
                  <th class=\"fw-bold\">Ticket</th>
                  <th class=\"fw-bold text-center\">Amount</th>
                  <th class=\"fw-bold text-center\">Total Revenue</th>
                </tr>
              </thead>
              <tbody>
                ";
        // line 141
        $context['_parent'] = $context;
        $context['_seq'] = twig_ensure_traversable(($context["bestselling"] ?? null));
        foreach ($context['_seq'] as $context["key"] => $context["ticket"]) {
            // line 142
            echo "                <tr>
                  <td><small>";
            // line 143
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["ticket"], "ticketName", [twig_get_attribute($this->env, $this->source, $context["ticket"], "ticket_id", [], "any", false, false, true, 143)], "method", false, false, true, 143), 143, $this->source), "html", null, true);
            echo "</small></td>
                  <td class=\" text-center\"><small>";
            // line 144
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["ticket"], "amount", [], "any", false, false, true, 144), 144, $this->source), "html", null, true);
            echo "</small></td>
                  <td class=\" text-center\"><small>IDR ";
            // line 145
            echo twig_escape_filter($this->env, $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, $context["ticket"], "priceFormat", [twig_get_attribute($this->env, $this->source, $context["ticket"], "revenue", [], "any", false, false, true, 145)], "method", false, false, true, 145), 145, $this->source), "html", null, true);
            echo "</small></td>
                </tr>
                ";
        }
        $_parent = $context['_parent'];
        unset($context['_seq'], $context['_iterated'], $context['key'], $context['ticket'], $context['_parent'], $context['loop']);
        $context = array_intersect_key($context, $_parent) + $_parent;
        // line 148
        echo "              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <!-- end country -->

    <!-- lead time statistic -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Lead Time Bookings</h5>
        </div>
        <div class=\"card-body\">
          <canvas id=\"barChart\" class=\"chartjs\" data-height=\"400\"></canvas>
        </div>
      </div>
    </div>
    <!-- end lead time statistic -->

  </div>
</div>
<!-- / Content -->


<!-- js -->
";
        // line 175
        echo $this->env->getExtension('Cms\Twig\Extension')->startBlock('scripts'        );
        // line 176
        echo "
<script type=\"text/javascript\">
  //  For Datatable
  // --------------------------------------------------------------------
  var dt_projects_table = \$('.datatables-projects');

  var dt_project = dt_projects_table.DataTable({

  });

  (function () {
    // Color Variables
    const purpleColor = '#836AF9',
    yellowColor = '#ffe800',
    cyanColor = '#28dac6',
    orangeColor = '#FF8132',
    orangeLightColor = '#FDAC34',
    oceanBlueColor = '#299AFF',
    greyColor = '#4F5D70',
    greyLightColor = '#EDF1F4',
    blueColor = '#2B9AFF',
    blueLightColor = '#84D0FF';

    let cardColor, headingColor, labelColor, borderColor, legendColor;

    if (isDarkStyle) {
      cardColor = config.colors_dark.cardColor;
      headingColor = config.colors_dark.headingColor;
      labelColor = config.colors_dark.textMuted;
      legendColor = config.colors_dark.bodyColor;
      borderColor = config.colors_dark.borderColor;
    } else {
      cardColor = config.colors.cardColor;
      headingColor = config.colors.headingColor;
      labelColor = config.colors.textMuted;
      legendColor = config.colors.bodyColor;
      borderColor = config.colors.borderColor;
    }

    // Set height according to their data-height
    const chartList = document.querySelectorAll('.chartjs');
    chartList.forEach(function (chartListItem) {
      chartListItem.height = chartListItem.dataset.height;
    });

    // Prepare data for the chart
    const leadTimeData = ";
        // line 222
        echo $this->sandbox->ensureToStringAllowed(twig_get_attribute($this->env, $this->source, ($context["booking"] ?? null), "leadTime", [($context["vendor"] ?? null)], "method", false, false, true, 222), 222, $this->source);
        echo ";
    const labels = [];
    const data = [];

    leadTimeData.forEach(item => {
      labels.push(item.lead_time_group);
      data.push(item.total_bookings);
    });

    // Bar Chart
    const barChart = document.getElementById('barChart');
    if (barChart) {
      const barChartVar = new Chart(barChart, {
        type: 'bar',
        data: {
          labels: labels,
          datasets: [
          {
            data: data,
            backgroundColor: cyanColor,
            borderColor: 'transparent',
            maxBarThickness: 50,
            borderRadius: {
              topRight: 0,
              topLeft: 0
            }
          }
          ]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          animation: {
            duration: 500
          },
          plugins: {
            tooltip: {
              rtl: isRtl,
              backgroundColor: cardColor,
              titleColor: headingColor,
              bodyColor: legendColor,
              borderWidth: 1,
              borderColor: borderColor
            },
            legend: {
              display: false
            }
          },
          scales: {
            x: {
              grid: {
                color: borderColor,
                drawBorder: false,
                borderColor: borderColor
              },
              ticks: {
                color: labelColor
              }
            },
            y: {
              min: 0,
              grid: {
                color: borderColor,
                drawBorder: false,
                borderColor: borderColor
              },
              ticks: {
                stepSize: Math.ceil((Math.max(...data) + 28.5) / 2),
                color: labelColor
              }
            }
          }
        }
      });
    }
  })();
</script>

";
        // line 301
        echo "<script>
  // Data dari backend
  const trackingData = ";
        // line 303
        echo json_encode($this->sandbox->ensureToStringAllowed(($context["countries"] ?? null), 303, $this->source));
        echo ";
  const countries = trackingData.map(item => item.country);
  const totals = trackingData.map(item => parseInt(item.revenue, 10));

  // Mencari nilai terbesar
  const maxTotal = Math.max(...totals);
  const maxTotalDevice = countries[totals.indexOf(maxTotal)];

  // Formatter mata uang IDR
  const formatToIDR = (value) =>
    new Intl.NumberFormat('id-ID', { style: 'currency', currency: 'IDR' }).format(value);

  // Warna chart
  const chartColors = ['#FFB800', '#299AFF', '#836AF9', '#28DAC6'];

  // Konfigurasi Donut Chart
  const donutChartEl = document.querySelector('#donutChart');
  if (donutChartEl) {
    const donutChartConfig = {
      chart: {
        type: 'donut',
        height: 390,
      },
      labels: countries,
      series: totals,
      colors: chartColors,
      legend: {
        position: 'bottom',
      },
      plotOptions: {
        pie: {
          donut: {
            labels: {
              show: true,
              name: {
                fontSize: '1.5rem',
              },
              value: {
                fontSize: '1rem',
                formatter: val => formatToIDR(val), // Format ke IDR
              },
              total: {
                show: true,
                label: maxTotalDevice,
                formatter: () => formatToIDR(maxTotal), // Total juga diformat ke IDR
              },
            },
          },
        },
      },
      tooltip: {
        y: {
          formatter: (val) => formatToIDR(val), // Tooltip diformat ke IDR
        },
      },
    };

    const donutChart = new ApexCharts(donutChartEl, donutChartConfig);
    donutChart.render();
  }
</script>

";
        // line 175
        echo $this->env->getExtension('Cms\Twig\Extension')->endBlock(true        );
        // line 366
        echo "<!-- end js -->";
    }

    /**
     * @codeCoverageIgnore
     */
    public function getTemplateName()
    {
        return "/home/tiketxplorer/public_html/main_tiketxplorer/themes/balitiket/pages/dashboard/dashboard.htm";
    }

    /**
     * @codeCoverageIgnore
     */
    public function isTraitable()
    {
        return false;
    }

    /**
     * @codeCoverageIgnore
     */
    public function getDebugInfo()
    {
        return array (  495 => 366,  493 => 175,  428 => 303,  424 => 301,  343 => 222,  295 => 176,  293 => 175,  264 => 148,  255 => 145,  251 => 144,  247 => 143,  244 => 142,  240 => 141,  206 => 114,  188 => 98,  180 => 95,  174 => 93,  172 => 92,  168 => 90,  164 => 88,  162 => 87,  159 => 86,  157 => 85,  154 => 84,  152 => 83,  147 => 81,  143 => 80,  139 => 79,  135 => 78,  131 => 77,  128 => 76,  124 => 75,  93 => 47,  74 => 31,  55 => 15,  39 => 1,);
    }

    public function getSourceContext()
    {
        return new Source("<!-- Content -->

<div class=\"container-xxl flex-grow-1 container-p-y\">
  <div class=\"row\">

    <!-- revenue -->
    <div class=\"col-6 col-xl-4 col-sm-6 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Last 30 Days Revenue</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"d-flex gap-2 align-items-center\">
            <div class=\"badge rounded bg-label-info p-1\"><i class=\"ti ti-chart-pie-2 ti-sm\"></i></div>
            <h4 class=\"mb-0\">{{booking.revenueThirtyDays(vendor)}} IDR</h4>
          </div>
        </div>
      </div>
    </div>

    <div class=\"col-6 col-xl-4 col-sm-6 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Today's Revenue</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"d-flex gap-2 align-items-center\">
            <div class=\"badge rounded bg-label-primary p-1\">
              <i class=\"ti ti-currency-dollar ti-sm\"></i>
            </div>
            <h4 class=\"mb-0\">{{booking.revenueToday(vendor)}} IDR</h4>
          </div>
        </div>
      </div>
    </div>

    <div class=\"col-6 col-xl-4 col-sm-6 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Last 30 Days Tickets Sold</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"d-flex gap-2 align-items-center\">
            <div class=\"badge rounded bg-label-warning p-1\">
              <i class=\"ti ti-ticket ti-sm\"></i>
            </div>
            <h4 class=\"mb-0\">{{booking.saleThirtyDays(vendor)}} Tickets</h4>
          </div>
        </div>
      </div>
    </div>
    <!-- end revenue -->

    <!-- recent bookings -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Recent Bookings</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"card-datatable table-responsive\">
            <table class=\"table border-top\" id=\"recent-booking-list\">
              <thead>
                <tr class=\"\" >
                  <th class=\"fw-bold\">No. Invoice</th>
                  <th class=\"fw-bold\">Booking Date</th>
                  <th class=\"fw-bold\">Name</th>
                  <th class=\"fw-bold\">Arrival Date</th>
                  <th class=\"fw-bold\">Amount</th>
                  <th class=\"fw-bold\">Status Payment</th>
                  <th class=\"fw-bold\"></th>
                </tr>
              </thead>
              <tbody>
                {% for booking in bookings %}
                <tr>
                  <td>{{ booking.no_invoice }}</td>
                  <td>{{ booking.invoice_date }}</td>
                  <td>{{ booking.firstname }}</td>
                  <td>{{ booking.arrival_date }}</td>
                  <td>IDR {{ booking.priceFormat(booking.total_price) }}</td>
                  <td>
                    {% if booking.status_payment == 'pending' %}
                    <span class=\"badge bg-warning\">pending</span>
                    {% elseif booking.status_payment == 'paid' %}
                    <span class=\"badge bg-success\">paid</span>
                    {% elseif booking.status_payment == 'expired' %}
                    <span class=\"badge bg-danger\">expired</span>
                    {% endif %}
                  </td>
                  <td class=\"text-end\">
                    {% if booking.voucher_link != null and booking.status_payment == 'paid' %}
                    <a class=\"btn btn-primary btn-sm\" href=\"https://main.tiketxplorer.com/bali_tiket/{{booking.voucher_link}}\" target=\"_blank\"><i class=\"fa fa-eye me-2\"></i>view</a>
                    {% endif %}
                  </td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <!-- end recent bookings -->

    <!-- country -->
    <div class=\"col-md-6 col-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header d-flex align-items-center justify-content-between\">
          <div>
            <h5 class=\"card-title mb-0\">Last 30 Days Revenue by Country</h5>
          </div>
          <div class=\"dropdown d-none d-sm-flex\">
            <h5 class=\"mb-0 me-3\"><small class=\"text-muted\">{{ (from != null) ? from|date('d F Y') : '' }} <span class=\"mx-2\">{{ (to != null) ? '-' : '' }}</span> {{ (to != null) ? to|date('d F Y') : '' }}</small></h5>
          </div>
        </div>
        <div class=\"card-body\">
          <div id=\"donutChart\"></div>
        </div>
      </div>
    </div>
    <!-- end country -->

    <!-- country -->
    <div class=\"col-12 col-xl-6 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Best-Selling Tickets in the Last 30 Days</h5>
        </div>
        <div class=\"card-body\">
          <div class=\"card-datatable table-responsive\">
            <table class=\"table border-top\" id=\"recent-booking-list\">
              <thead>
                <tr class=\"\" >
                  <th class=\"fw-bold\">Ticket</th>
                  <th class=\"fw-bold text-center\">Amount</th>
                  <th class=\"fw-bold text-center\">Total Revenue</th>
                </tr>
              </thead>
              <tbody>
                {% for key, ticket in bestselling %}
                <tr>
                  <td><small>{{ ticket.ticketName(ticket.ticket_id) }}</small></td>
                  <td class=\" text-center\"><small>{{ ticket.amount }}</small></td>
                  <td class=\" text-center\"><small>IDR {{ ticket.priceFormat(ticket.revenue) }}</small></td>
                </tr>
                {% endfor %}
              </tbody>
            </table>
          </div>
        </div>
      </div>
    </div>
    <!-- end country -->

    <!-- lead time statistic -->
    <div class=\"col-12 col-xl-12 col-sm-12 mb-4\">
      <div class=\"card\">
        <div class=\"card-header header-elements\">
          <h5 class=\"card-title mb-0\">Lead Time Bookings</h5>
        </div>
        <div class=\"card-body\">
          <canvas id=\"barChart\" class=\"chartjs\" data-height=\"400\"></canvas>
        </div>
      </div>
    </div>
    <!-- end lead time statistic -->

  </div>
</div>
<!-- / Content -->


<!-- js -->
{% put scripts %}

<script type=\"text/javascript\">
  //  For Datatable
  // --------------------------------------------------------------------
  var dt_projects_table = \$('.datatables-projects');

  var dt_project = dt_projects_table.DataTable({

  });

  (function () {
    // Color Variables
    const purpleColor = '#836AF9',
    yellowColor = '#ffe800',
    cyanColor = '#28dac6',
    orangeColor = '#FF8132',
    orangeLightColor = '#FDAC34',
    oceanBlueColor = '#299AFF',
    greyColor = '#4F5D70',
    greyLightColor = '#EDF1F4',
    blueColor = '#2B9AFF',
    blueLightColor = '#84D0FF';

    let cardColor, headingColor, labelColor, borderColor, legendColor;

    if (isDarkStyle) {
      cardColor = config.colors_dark.cardColor;
      headingColor = config.colors_dark.headingColor;
      labelColor = config.colors_dark.textMuted;
      legendColor = config.colors_dark.bodyColor;
      borderColor = config.colors_dark.borderColor;
    } else {
      cardColor = config.colors.cardColor;
      headingColor = config.colors.headingColor;
      labelColor = config.colors.textMuted;
      legendColor = config.colors.bodyColor;
      borderColor = config.colors.borderColor;
    }

    // Set height according to their data-height
    const chartList = document.querySelectorAll('.chartjs');
    chartList.forEach(function (chartListItem) {
      chartListItem.height = chartListItem.dataset.height;
    });

    // Prepare data for the chart
    const leadTimeData = {{ booking.leadTime(vendor) | raw }};
    const labels = [];
    const data = [];

    leadTimeData.forEach(item => {
      labels.push(item.lead_time_group);
      data.push(item.total_bookings);
    });

    // Bar Chart
    const barChart = document.getElementById('barChart');
    if (barChart) {
      const barChartVar = new Chart(barChart, {
        type: 'bar',
        data: {
          labels: labels,
          datasets: [
          {
            data: data,
            backgroundColor: cyanColor,
            borderColor: 'transparent',
            maxBarThickness: 50,
            borderRadius: {
              topRight: 0,
              topLeft: 0
            }
          }
          ]
        },
        options: {
          responsive: true,
          maintainAspectRatio: false,
          animation: {
            duration: 500
          },
          plugins: {
            tooltip: {
              rtl: isRtl,
              backgroundColor: cardColor,
              titleColor: headingColor,
              bodyColor: legendColor,
              borderWidth: 1,
              borderColor: borderColor
            },
            legend: {
              display: false
            }
          },
          scales: {
            x: {
              grid: {
                color: borderColor,
                drawBorder: false,
                borderColor: borderColor
              },
              ticks: {
                color: labelColor
              }
            },
            y: {
              min: 0,
              grid: {
                color: borderColor,
                drawBorder: false,
                borderColor: borderColor
              },
              ticks: {
                stepSize: Math.ceil((Math.max(...data) + 28.5) / 2),
                color: labelColor
              }
            }
          }
        }
      });
    }
  })();
</script>

{# donut chart #}
<script>
  // Data dari backend
  const trackingData = {{ countries | json_encode | raw }};
  const countries = trackingData.map(item => item.country);
  const totals = trackingData.map(item => parseInt(item.revenue, 10));

  // Mencari nilai terbesar
  const maxTotal = Math.max(...totals);
  const maxTotalDevice = countries[totals.indexOf(maxTotal)];

  // Formatter mata uang IDR
  const formatToIDR = (value) =>
    new Intl.NumberFormat('id-ID', { style: 'currency', currency: 'IDR' }).format(value);

  // Warna chart
  const chartColors = ['#FFB800', '#299AFF', '#836AF9', '#28DAC6'];

  // Konfigurasi Donut Chart
  const donutChartEl = document.querySelector('#donutChart');
  if (donutChartEl) {
    const donutChartConfig = {
      chart: {
        type: 'donut',
        height: 390,
      },
      labels: countries,
      series: totals,
      colors: chartColors,
      legend: {
        position: 'bottom',
      },
      plotOptions: {
        pie: {
          donut: {
            labels: {
              show: true,
              name: {
                fontSize: '1.5rem',
              },
              value: {
                fontSize: '1rem',
                formatter: val => formatToIDR(val), // Format ke IDR
              },
              total: {
                show: true,
                label: maxTotalDevice,
                formatter: () => formatToIDR(maxTotal), // Total juga diformat ke IDR
              },
            },
          },
        },
      },
      tooltip: {
        y: {
          formatter: (val) => formatToIDR(val), // Tooltip diformat ke IDR
        },
      },
    };

    const donutChart = new ApexCharts(donutChartEl, donutChartConfig);
    donutChart.render();
  }
</script>

{% endput %}
<!-- end js -->", "/home/tiketxplorer/public_html/main_tiketxplorer/themes/balitiket/pages/dashboard/dashboard.htm", "");
    }
    
    public function checkSecurity()
    {
        static $tags = array("for" => 75, "if" => 83, "put" => 175);
        static $filters = array("escape" => 15, "date" => 114, "raw" => 222, "json_encode" => 303);
        static $functions = array();

        try {
            $this->sandbox->checkSecurity(
                ['for', 'if', 'put'],
                ['escape', 'date', 'raw', 'json_encode'],
                []
            );
        } catch (SecurityError $e) {
            $e->setSourceContext($this->source);

            if ($e instanceof SecurityNotAllowedTagError && isset($tags[$e->getTagName()])) {
                $e->setTemplateLine($tags[$e->getTagName()]);
            } elseif ($e instanceof SecurityNotAllowedFilterError && isset($filters[$e->getFilterName()])) {
                $e->setTemplateLine($filters[$e->getFilterName()]);
            } elseif ($e instanceof SecurityNotAllowedFunctionError && isset($functions[$e->getFunctionName()])) {
                $e->setTemplateLine($functions[$e->getFunctionName()]);
            }

            throw $e;
        }

    }
}
