<?php 
use Yuren\BaliTiket\Models\Bookings;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Guestlist;
use Winter\Storm\Auth\AuthManager;
use Carbon\Carbon;
class Cms677b4aa31dd38626794122_4af0ebbd5c5a688a435ef5a6ad3e4e10Class extends Cms\Classes\PageCode
{
public function onStart()
    {
        $dateNow = date('Y-m-d');
        $this['dateNow'] = date('d, F Y');
        $tomorrow = date('Y-m-d', strtotime('+1 day'));
        $lastWeek = date('Y-m-d', strtotime('-7 day'));

        // Query data dari database
        $guestCounts = Bookings::selectRaw('DATE(arrival_date) as date, SUM(person) as total')
            ->where('status_payment', 'paid')
            ->whereBetween('arrival_date', [$lastWeek, $dateNow])
            ->groupBy('date')
            ->orderBy('date', 'asc')
            ->get();

        $checkins = Guestlist::selectRaw('DATE(datetime) as date, COUNT(*) as total')
            ->whereBetween('datetime', [$lastWeek, $tomorrow])
            ->groupBy('date')
            ->orderBy('date', 'asc')
            ->get();

        // Format data untuk chart.js
        $this['chartData'] = json_encode([
            'labels' => $guestCounts->pluck('date'), // Tanggal dari bookings
            'datasets' => [
                [
                    'label' => 'Number of Guests',
                    'data' => $guestCounts->pluck('total'), // Jumlah tamu
                    'backgroundColor' => 'rgba(255, 99, 132, 0.5)',
                    'borderColor' => 'rgba(255, 99, 132, 1)',
                    'fill' => false,
                    'tension' => 0.4,
                ],
                [
                    'label' => 'Guest Check-in',
                    'data' => $checkins->pluck('total'), // Jumlah check-in
                    'backgroundColor' => 'rgba(54, 162, 235, 0.5)',
                    'borderColor' => 'rgba(54, 162, 235, 1)',
                    'fill' => false,
                    'tension' => 0.4,
                ],
            ],
        ]);

        $this['guestCount'] = Bookings::where('status_payment', 'paid')->whereRaw('DATE(arrival_date) = ?', [$dateNow])->sum('person');
        $this['guestCheckinCount'] = Guestlist::orderBy('no_invoice', 'asc')->whereRaw('DATE(datetime) = ?', [$dateNow])->count();
    }
}
