<?php 
use Yuren\BaliTiket\Models\Tracking;
use Yuren\BaliTiket\Models\Bookings;
use Winter\Storm\Auth\AuthManager;
class Cms6703874c3983a147579487_5c72fe51df4244a0001b4618e37e3bb1Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['from'] = Input::get('from');
      $this['to'] = Input::get('to');
      $from = Input::get('from');
      $to = Input::get('to');

      $this['vendor'] = $user->vendor; 

      $trackings = Tracking::selectRaw('MIN(title) as title, url, COUNT(*) as total')->where('vendor', $user->vendor)->groupBy('url')->orderBy('total', 'desc');
      if ($from != null) {
        $trackings->where('created_at', '>=', $from);
      }
      if ($to != null) {
        $trackings->where('created_at', '<=', $to);
      }
      $this['trackings'] = $trackings->get();

      $this['all_tracking'] = Tracking::where('vendor', $user->vendor)->count();

      $tracking_by_date = Tracking::selectRaw('DATE(created_at) as date, COUNT(*) as total')->where('vendor', $user->vendor)->groupBy('date')->orderBy('date', 'asc');
      if ($from != null) {
        $tracking_by_date->where('created_at', '>=', $from);
      }
      if ($to != null) {
        $tracking_by_date->where('created_at', '<=', $to);
      }
      $this['tracking_by_date'] = $tracking_by_date->get();


    } 

    
  }
}
