<?php 
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Rateplan;
use Winter\Storm\Auth\AuthManager;
class Cms6735bd34c1419516974308_f1086053db285911f3263fc33d2cf220Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor; 

      $this['tickets'] = Ticket::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();

      $this['rateplans'] = Rateplan::orderBy('created_at', 'asc')->where('vendor_id', $user->vendor)->get();

      $this['active_ticket'] = Ticket::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->where('published', 1)->count();

      $this['all_ticket'] = Ticket::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->count();
    } 

    $this['ticket'] = Ticket::make();
  }
public function onDelete()
  {
    $ticketId = Input::post('id_ticket');

    $ticket = Ticket::find($ticketId);
    if ($ticket) {
      $ticket->delete();
    }

    return redirect()->refresh();
  }
public function onDeleteRateplan()
  {
    $rateplanId = Input::post('id_rateplan');

    $rateplan = Rateplan::find($rateplanId);
    if ($rateplan) {
      $rateplan->delete();
    }

    return redirect()->refresh();
  }
}
