<?php 
use Yuren\BaliTiket\Models\Device;
use Yuren\BaliTiket\Models\Tracking;
use Yuren\BaliTiket\Models\Bookings;
use Winter\Storm\Auth\AuthManager;
class Cms6703875c9a76b089036828_d16a638470ae2b3c28017dc5e73e2524Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['from'] = Input::get('from');
      $this['to'] = Input::get('to');
      $from = Input::get('from');
      $to = Input::get('to');

      $this['vendor'] = $user->vendor; 

      $devices = Device::selectRaw('device, COUNT(*) as total')->where('vendor', $user->vendor)->groupBy('device')->orderBy('total', 'desc');
      if ($from != null) {
        $devices->where('created_at', '>=', $from);
      }
      if ($to != null) {
        $devices->where('created_at', '<=', $to);
      }
      $this['devices'] = $devices->get();

      $this['all_device'] = Device::where('vendor', $user->vendor)->count();

      $device_by_date = Device::selectRaw('device, COUNT(*) as total')->where('vendor', $user->vendor)->groupBy('device')->orderBy('total', 'asc');
      if ($from != null) {
        $device_by_date->where('created_at', '>=', $from);
      }
      if ($to != null) {
        $device_by_date->where('created_at', '<=', $to);
      }
      $this['device_by_date'] = $device_by_date->get();
    } 

    
  }
}
