<?php 
use Yuren\BaliTiket\Models\Country;
use Yuren\BaliTiket\Models\Bookings;
use Winter\Storm\Auth\AuthManager;
class Cms67038758b8326293407651_710b23178568d91d4b2b3194b77cfe93Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['from'] = Input::get('from');
      $this['to'] = Input::get('to');
      $from = Input::get('from');
      $to = Input::get('to');

      $this['vendor'] = $user->vendor; 

      $country = Country::selectRaw('country, COUNT(*) as total')->where('vendor', $user->vendor)->groupBy('country')->orderBy('total', 'desc');
      if ($from != null) {
        $country->where('created_at', '>=', $from);
      }
      if ($to != null) {
        $country->where('created_at', '<=', $to);
      }
      $this['country'] = $country->get();

      $bookings = Bookings::selectRaw('country, SUM(total_price) as revenue')->where('vendor_id', $user->vendor)->where('status_payment', 'paid')->groupBy('country');
      if ($from != null) {
        $bookings->where('invoice_date', '>=', $from);
      }
      if ($to != null) {
        $bookings->where('invoice_date', '<=', $to);
      }
      $this['bookings'] = $bookings->get();

      $this['all_browser'] = Country::where('vendor', $user->vendor)->count();

      $country_by_date = Country::selectRaw('DATE(created_at) as date, COUNT(*) as total')->where('vendor', $user->vendor)->groupBy('date')->orderBy('date', 'asc');
      if ($from != null) {
        $country_by_date->where('created_at', '>=', $from);
      }
      if ($to != null) {
        $country_by_date->where('created_at', '<=', $to);
      }
      $this['country_by_date'] = $country_by_date->get();
    } 

    $this['booking'] = Bookings::make();
    
  }
}
