<?php 
use Yuren\BaliTiket\Models\Bookings;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Ticket;
use Winter\Storm\Auth\AuthManager;
class Cms67762f1467608979407254_8436c553456f95ba49d76be376935667Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor; 

      $name = Input::get('name');
      $type = Input::get('type');
      $from = Input::get('from');
      $to = Input::get('to');
      $no_invoice = Input::get('no_invoice');
      $status = Input::get('status');
      $product = Input::get('product');

      $this['name'] = Input::get('name');
      $this['type'] = Input::get('type');
      $this['from'] = Input::get('from');
      $this['to'] = Input::get('to');
      $this['no_invoice'] = Input::get('no_invoice');
      $this['status'] = Input::get('status');
      $this['product'] = Input::get('product');

      $query = Bookings::where('vendor_id', $user->vendor);

      if ($name != null) {
        $query->where('name', 'like', '%' . $name . '%');
      }

      if ($type != null) {

        if ($type == 'Booking Date'){
          if ($from != null) {
            $query->where('invoice_date', '>=', $from);
          }

          if ($to != null) {
            $query->where('invoice_date', '<=', $to);
          }
        } elseif ($type == 'Arrival Date'){
          if ($from != null) {
            $query->where('arrival_date', '>=', $from);
          }

          if ($to != null) {
            $query->where('arrival_date', '<=', $to);
          }
        }
      }

      if ($no_invoice != null) {
        $query->where('no_invoice', 'like', '%' . $no_invoice . '%');
      }

      if ($status != null) {
        $query->where('status_payment', $status);
      }

      if ($product != null) {
        $query->where('product_id', $product);
      }

      // Clone query for total revenue calculation
      $revenueQuery = clone $query;

      // Clone query for lead time calculation
      $leadTimeQuery = clone $query;

      // Get bookings
      $this['bookings'] = $query->orderBy('invoice_date', 'desc')->get();

      // Calculate total revenue
      $totalRevenue = $revenueQuery->where('status_payment', 'paid')->sum('total_price');
      // Format total revenue
      $this['totalRevenue'] = number_format($totalRevenue, 0, ',', '.');

      // Calculate lead time booking
      $this['leadtime'] = $leadTimeQuery->selectRaw("
      CASE
      WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 0 AND 7 THEN '0-7 days'
      WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 8 AND 14 THEN '7-14 days'
      WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 15 AND 30 THEN '14-30 days'
      WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 31 AND 90 THEN '1-3 months'
      WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 91 AND 365 THEN '3 months - 1 year'
      ELSE 'More than 1 year'
      END AS lead_time_group,
      COUNT(*) AS total_bookings
      ")
      ->where('status_payment', 'paid')
      ->groupBy('lead_time_group')
      ->orderByRaw("
          CASE
          WHEN lead_time_group = '0-7 days' THEN 1
          WHEN lead_time_group = '7-14 days' THEN 2
          WHEN lead_time_group = '14-30 days' THEN 3
          WHEN lead_time_group = '1-3 months' THEN 4
          WHEN lead_time_group = '3 months - 1 year' THEN 5
          WHEN lead_time_group = 'More than 1 year' THEN 6
          END
      ")
      ->get();


    } 

    $this['booking'] = Bookings::make();
  }
public function onDelete()
  {
    $bookingId = Input::post('id_booking');

    $booking = Bookings::find($bookingId);
    if ($booking) {
      $booking->delete();
    }

    return redirect()->refresh();
  }
}
