<?php 
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Blog;
use Yuren\BaliTiket\Models\Addon;
use System\Models\File;
use Winter\Storm\Auth\AuthManager;
class Cms6736fc82f41e7936224018_00632e6b8c9556bd997205cb4546d801Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['tickets'] = Ticket::where('id', $this->param('id'))->first();

      $this['addons'] = Addon::where('vendor_id', $user->vendor)->get();

      $this['blogs'] = Blog::orderBy('created_at', 'desc')->where('published', 1)->get();
    } 

    $this['ticket'] = Ticket::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = Ticket::where('id', $this->param('id'))->first();
    $query->vendor_id = Input::get('vendor');
    $query->blog_id = Input::get('blog');
    $query->name = Input::get('name');
    $query->slug = Input::get('slug');
    $query->description = Input::get('description');
    $query->short_desc = Input::get('short_desc');
    $query->highlight = Input::get('highlight');
    $query->start_time = Input::get('start_time');
    $query->end_time = Input::get('end_time');
    $query->cancellation = Input::get('cancellation');
    $query->terms = Input::get('terms');
    $query->availability = Input::get('availability');
    $query->images = Input::file('images');
    $query->other_img = Input::file('other_img');
    $query->updated_at = $dateNow;
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    //addon
    $addons = Input::get('Ticket')['addons'];
    $formattedAddons = [];
    foreach ($addons as $addon) {
      $formattedAddons[] = ['addon' => $addon['addon'], 'type' => $addon['type'], 'cost' => $addon['cost']];
    }
    $query->addons = $formattedAddons;
    
    //inclusion
    $items = Input::get('Ticket')['inclusion'];
    $formattedItems = [];
    foreach ($items as $item) {
      $formattedItems[] = ['item' => $item['item']];
    }
    $query->inclusion = $formattedItems;

    //facilities
    $names = Input::get('Ticket')['facilities'];
    $formattedItems = [];
    foreach ($names as $name) {
      $formattedItems[] = ['name' => $name['name']];
    }
    $query->facilities = $formattedItems;

    $location = [
    'address' => Input::get('address'),
    'address_link' => Input::get('address_link')
    ];
    $query->location = $location;

    $query->save();

    // Set flash message
    Session::flash('success', 'Ticket has been added successfully.');

    // Redirect to the product page
    return redirect('/ticket');
  }

  public function onDeleteImg()
  {
    // Get the image ID from the post data
    $imageId = post('id_img');

    // Find the image and delete it
    $image = File::find($imageId);
    if ($image) {
      $image->delete();
    }

    // Re-fetch the images
    $blog = Blog::find($this->param('id'));
    if (Input::post('type') == 'main'){
      $images = $blog->images;
    } elseif (Input::post('type') == 'other'){
      $images = $blog->other_img;
    } 

    // Return the updated partial
    if (Input::post('type') == 'main'){
      return ['#main-img-container' => $this->renderPartial('blog/main_images', ['images' => $images])];
    } elseif (Input::post('type') == 'other'){
      return ['#other-img-container' => $this->renderPartial('blog/other_images', ['images' => $images])];
    } 
  }
}
