<?php 
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Rateplan;
use Winter\Storm\Auth\AuthManager;
class Cms673bf31153da6042952746_0b0fe92af8368d48a35cc7e2894f9a40Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['ticket'] = Ticket::where('id', $this->param('ticketid'))->first();

      $this['rateplan'] = Rateplan::where('id', $this->param('id'))->first();
    } 

    $this['tickets'] = Ticket::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = Rateplan::where('id', $this->param('id'))->first();
    $query->name = Input::get('name');
    $query->slug = Input::get('slug');
    $query->min_purchase = Input::get('min_purchase');
    $query->max_purchase = Input::get('max_purchase');
    $query->ticket_id = Input::get('ticket_id');
    $query->vendor_id = Input::get('vendor_id');
    $query->fixed_price = Input::get('fixed_price');
    $query->description = Input::get('description');
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    $query->updated_at = $dateNow;

    $query->save();

    // Set flash message
    Session::flash('success', 'Rateplan has been added successfully.');

    // Redirect to the location page
    return redirect('/ticket');
  }
}
