<?php 
use Yuren\BaliTiket\Models\Product;
use Yuren\BaliTiket\Models\Vendor;
use System\Models\File;
use Winter\Storm\Auth\AuthManager;
class Cms66f28beed49cd877757376_4919287e0757ff7f18899e088fd54a64Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['products'] = Product::where('vendor_id', $user->vendor)->where('id', $this->param('id'))->first();
    } 

    $this['product'] = Product::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = Product::where('id', $this->param('id'))->first();
    $query->vendor_id = Input::get('vendor');
    $query->name = Input::get('name');
    $query->slug = Input::get('slug');
    $query->description = Input::get('description');
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    $query->highlight = Input::get('highlight');

    $items = Input::get('Product')['inclusion'];
    // Mengubah array menjadi format yang diinginkan
    $formattedItems = [];
    foreach ($items as $item) {
      $formattedItems[] = ['item' => $item['item']];
    }
    $query->inclusion = $formattedItems;
    
    $query->type = Input::get('type');
    $query->short_desc = Input::get('short_desc');
    $query->category = Input::get('category');
    $query->link_url = Input::get('link_url');
    $query->link_address = Input::get('link_address');
    $query->address = Input::get('address');
    $query->images = Input::file('images');
    $query->facilities = Input::file('facilities');
    $query->map = Input::file('map');
    $query->updated_at = $dateNow;

    $query->save();

    Session::flash('success', 'Product has been update successfully.');

    return redirect('/product');
  }

  public function onDeleteImg()
  {
    // Get the image ID from the post data
    $imageId = post('id_img');

    // Find the image and delete it
    $image = File::find($imageId);
    if ($image) {
      $image->delete();
    }

    // Re-fetch the images
    $product = Product::find($this->param('id'));
    if (Input::post('type') == 'main'){
      $images = $product->images;
    } elseif (Input::post('type') == 'facilities'){
      $images = $product->facilities;
    } elseif (Input::post('type') == 'map'){
      $images = $product->map;
    } 

    // Return the updated partial
    if (Input::post('type') == 'main'){
      return ['#main-img-container' => $this->renderPartial('product/main_images', ['images' => $images])];
    } elseif (Input::post('type') == 'facilities'){
      return ['#facilities-container' => $this->renderPartial('product/facilities', ['images' => $images])];
    } elseif (Input::post('type') == 'map'){
      return ['#map-container' => $this->renderPartial('product/map', ['images' => $images])];
    } 
  }
}
