<?php 
use Yuren\BaliTiket\Models\Location;
use System\Models\File;
use Winter\Storm\Auth\AuthManager;
class Cms66f3ce5690c9d199766667_e333b05ac547ec193b6c8676e922abd4Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['locations'] = Location::where('id', $this->param('id'))->first();
    } 

    $this['location'] = Location::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = Location::where('id', $this->param('id'))->first();
    $query->name = Input::get('name');
    $query->slug = Input::get('slug');
    $query->description = Input::get('description');
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    $query->map_area_link = Input::get('map_area_link');
    $query->main_img = Input::file('main_img');
    $query->other_img = Input::file('other_img');
    $query->updated_at = $dateNow;

    $query->save();

    Session::flash('success', 'Location has been update successfully.');

    return redirect('/location');
  }

  public function onDeleteImg()
  {
    // Get the image ID from the post data
    $imageId = post('id_img');

    // Find the image and delete it
    $image = File::find($imageId);
    if ($image) {
      $image->delete();
    }

    // Re-fetch the images
    $location = Location::find($this->param('id'));
    if (Input::post('type') == 'main'){
      $images = $location->main_img;
    } elseif (Input::post('type') == 'other'){
      $images = $location->other_img;
    }

    // Return the updated partial
    if (Input::post('type') == 'main'){
      return ['#main-img-container' => $this->renderPartial('location/main_images', ['images' => $images])];
    } elseif (Input::post('type') == 'facilities'){
      return ['#other-img-container' => $this->renderPartial('location/other_images', ['images' => $images])];
    }
  }
}
