<?php 
use Yuren\BaliTiket\Models\Category;
use System\Models\File;
use Winter\Storm\Auth\AuthManager;
class Cms6751212add9d8842095451_57112f72fd34059002b46b75a79cfbffClass extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['categorys'] = Category::where('id', $this->param('id'))->first();
    } 

    $this['category'] = Category::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = Category::where('id', $this->param('id'))->first();
    $query->name = Input::get('name');
    $query->slug = Input::get('slug');
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    if(Input::get('main') == 'on'){
      $query->main = 1;
    } else {
      $query->main = 0;
    }

    $query->icon_desktop = Input::file('icon_desktop');
    $query->icon_mobile = Input::file('icon_mobile');
    $query->updated_at = $dateNow;

    $query->save();

    Session::flash('success', 'Category has been update successfully.');

    return redirect('/category');
  }

  public function onDeleteImg()
  {
    // Get the image ID from the post data
    $imageId = post('id_img');

    // Find the image and delete it
    $image = File::find($imageId);
    if ($image) {
      $image->delete();
    }

    // Re-fetch the images
    $category = Category::find($this->param('id'));
    if (Input::post('type') == 'main'){
      $images = $category->icon_desktop;
    } 

    if (Input::post('type') == 'other'){
      $images = $category->icon_mobile;
    } 

    // Return the updated partial
    if (Input::post('type') == 'main'){
      return ['#main-img-container' => $this->renderPartial('category/icon_desktop', ['images' => $images])];
    } 

    if (Input::post('type') == 'other'){
      return ['#other-img-container' => $this->renderPartial('category/icon_mobile', ['images' => $images])];
    } 
  }
}
