<?php 
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Allocation;
use Yuren\BaliTiket\Models\Bookings;
use Winter\Storm\Auth\AuthManager;
class Cms672c619947ddd447924155_bb3a7546ac00bf73def02ac1ae441678Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    date_default_timezone_set('Asia/Singapore');

    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['bookings'] = Bookings::where('id', $this->param('id'))->first();

      $this['tickets'] = Ticket::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();

      $this['allocations'] = Allocation::where('vendor_id', $user->vendor)->get();
    } 

    $this['allocation'] = Allocation::make();
  }
public function onUpdate()
  {
    date_default_timezone_set('Asia/Singapore');

    $vendor = Input::post('vendor2');
    $arrival_date = Input::post('arrival_date');
    $this['arrival_date'] = Input::post('arrival_date');

    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['bookings'] = Bookings::where('id', $this->param('id'))->first();

      $this['tickets'] = Ticket::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();

      $this['allocations'] = Allocation::where('vendor_id', $user->vendor)->get();
    } 

    $this['ticket'] = Ticket::make();
    $this['allocation'] = Allocation::make();

    return ['#list-ticket-container' => $this->renderPartial('booking/list_ticket_edit')];
  }
}
