<?php 
use Yuren\BaliTiket\Models\Blog;
use Yuren\BaliTiket\Models\Category;
use Yuren\BaliTiket\Models\Location;
use System\Models\File;
use Winter\Storm\Auth\AuthManager;
class Cms66f65d9d937f3902953074_8a03ae72e83ee8edbfa4a23aa47916b4Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['category'] = Category::orderBy('created_at', 'desc')->get();

      $this['location'] = Location::orderBy('created_at', 'desc')->get();

      $this['blogs'] = Blog::where('id', $this->param('id'))->first();
    } 

    $this['blog'] = Blog::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = Blog::where('id', $this->param('id'))->first();
    $query->location_id = Input::get('location');
    $query->activity_id = Input::get('activity_id');
    $query->title = Input::get('title');
    $query->slug = Input::get('slug');
    $query->age_requirements = Input::get('age_requirements');
    $query->duration = Input::get('duration');
    $query->description = Input::get('description');
    $query->highlight = Input::get('highlight');
    $query->category = Input::get('category');
    $query->images = Input::file('images');
    $query->other_img = Input::file('other_img');
    $query->updated_at = $dateNow;
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    //guides
    if(Input::get('guides') == 'on'){
      $query->guides = 1;
    } else {
      $query->guides = 0;
    }

    //lunch
    if(Input::get('lunch') == 'on'){
      $query->lunch = 1;
    } else {
      $query->lunch = 0;
    }

    $lists = Input::get('Blog')['inclusion'];
    // Mengubah array menjadi format yang diinginkan
    $formattedItems = [];
    foreach ($lists as $list) {
      $formattedItems[] = ['list' => $list['list']];
    }
    $query->inclusion = $formattedItems;

    $names = Input::get('Blog')['facilities'];
    // Mengubah array menjadi format yang diinginkan
    $formattedItems = [];
    foreach ($names as $name) {
      $formattedItems[] = ['name' => $name['name']];
    }
    $query->facilities = $formattedItems;

    $query->save();

    Session::flash('success', 'Blog has been update successfully.');

    return redirect('/blog');
  }

  public function onDeleteImg()
  {
    // Get the image ID from the post data
    $imageId = post('id_img');

    // Find the image and delete it
    $image = File::find($imageId);
    if ($image) {
      $image->delete();
    }

    // Re-fetch the images
    $blog = Blog::find($this->param('id'));
    if (Input::post('type') == 'main'){
      $images = $blog->images;
    } elseif (Input::post('type') == 'other'){
      $images = $blog->other_img;
    } 

    // Return the updated partial
    if (Input::post('type') == 'main'){
      return ['#main-img-container' => $this->renderPartial('blog/main_images', ['images' => $images])];
    } elseif (Input::post('type') == 'other'){
      return ['#other-img-container' => $this->renderPartial('blog/other_images', ['images' => $images])];
    } 
  }
}
