<?php 
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Addon;
use Winter\Storm\Auth\AuthManager;
class Cms6735c6afa8d1e862414893_966344f0e0084a9aa04d5c57476be22cClass extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['addon'] = Addon::where('id', $this->param('id'))->first();
    } 

  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = Addon::where('id', $this->param('id'))->first();
    $query->name = Input::get('name');
    $query->description = Input::get('description');
    $query->vendor_id = Input::get('vendor_id');
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    $query->updated_at = $dateNow;

    $query->save();

    // Set flash message
    Session::flash('success', 'Add On has been update successfully.');

    // Redirect to the location page
    return redirect('/addon');
  }
}
