<?php 
use Yuren\BaliTiket\Models\Bookings;
use Winter\Storm\Auth\AuthManager;
class Cms677b4eebd7bd4475351986_18987967fd4af744cc40a421b3f1857aClass extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor; 

      $thirtyDaysAgo = now()->subDays(30)->toDateString();

      $this['bookings'] = Bookings::orderBy('invoice_date', 'desc')->where('status_payment', 'paid')->where('vendor_id', $user->vendor)->take(10)->get();

      $this['countries'] = Bookings::selectRaw('country, SUM(total_price) as revenue')
      ->where('vendor_id', $user->vendor)
      ->where('status_payment', 'paid')
      ->where('invoice_date', '>=', $thirtyDaysAgo)
      ->groupBy('country')
      ->orderBy('revenue', 'desc')
      ->take(5) 
      ->get();

      $this['bestselling'] = Bookings::selectRaw('ticket_id, SUM(person) as amount, SUM(total_price) as revenue')
      ->where('vendor_id', $user->vendor)
      ->where('status_payment', 'paid')
      ->groupBy('ticket_id')
      ->orderBy('revenue', 'desc')
      ->take(5) 
      ->get();

    } 

    $this['booking'] = Bookings::make();
  }
}
