<?php 
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Rateplan;
use Yuren\BaliTiket\Models\Allocation;
use Winter\Storm\Auth\AuthManager;
class Cms673c4ef6774b9403246522_0cedcdbeeb1458ad8ae11284ba7e5625Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    date_default_timezone_set('Asia/Singapore');
    $this['arrival_date'] = date('Y-m-d');

    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['tickets'] = Ticket::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();

      $this['rateplans'] = Rateplan::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();

      $this['allocations'] = Allocation::where('vendor_id', $user->vendor)->get();
    } 

    $this['ticket'] = Ticket::make();
    $this['allocation'] = Allocation::make();
  }
public function onUpdate()
  {
    date_default_timezone_set('Asia/Singapore');

    $vendor = Input::post('vendor2');
    $arrival_date = Input::post('arrival_date');
    $this['arrival_date'] = Input::post('arrival_date');

    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['tickets'] = Ticket::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();

      $this['rateplans'] = Rateplan::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();

      $this['allocations'] = Allocation::where('vendor_id', $user->vendor)->get();
    } 

    $this['ticket'] = Ticket::make();
    $this['allocation'] = Allocation::make();

    return ['#list-ticket-container' => $this->renderPartial('booking/list_ticket')];
  }
}
