<?php 
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Allocation;
use Yuren\BaliTiket\Models\Rateplan;
use Winter\Storm\Auth\AuthManager;
use Carbon\Carbon;
class Cms673abfa54ca57516467810_465297819f8995fc2914491acb71b949Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;
      $this['tickets'] = Ticket::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();
      $this['rateplans'] = Rateplan::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();
      $this['allocations'] = Allocation::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();
    }

    // Get the selected month from request, default to current month
    $selectedMonth = Input::get('month', Carbon::now()->format('m-Y'));
    $this['selectedMonth'] = Input::get('month', Carbon::now()->format('m-Y'));

    // Get the first and last day of the selected month
    $startDate = Carbon::createFromFormat('m-Y', $selectedMonth)->startOfMonth();
    $endDate = Carbon::createFromFormat('m-Y', $selectedMonth)->endOfMonth();

    // If the selected month is the current month, start from today and add 30 days
    if ($startDate->isCurrentMonth()) {
      $startDate = Carbon::now(); // Start from today
      $endDate = Carbon::now()->addDays(30); // Add 30 days from today
    }

    // Generate the dates for the selected range
    $this['dates'] = collect();
    for ($date = $startDate; $date->lte($endDate); $date->addDay()) {
      $this['dates']->push($date->copy());
    }

    // Generate options for month selection (up to 2 years ahead)
    $currentMonth = Carbon::now();
    $endMonth = Carbon::now()->addYears(2);
    $this['option_dates'] = collect();
    for ($month = $currentMonth; $month->lte($endMonth); $month->addMonth()) {
      $this['option_dates']->push($month->copy());
    }

    $this['ticket'] = Ticket::make();
    $this['allocation'] = Allocation::make();
  }
public function onUpdate()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $vendor_id = Input::post('vendor_id');
    $filter_type = Input::post('filter_type');
    $percentage = Input::post('percentage');
    $value = Input::post('value');

    // Ambil bulan dari URL atau default jika tidak ada
    $month = Input::get('month', date('m-Y'));

    // Decode JSON data dari 'data_save'
    $data_save = json_decode(Input::post('data_save'), true);

    // Loop melalui data untuk update alokasi
    foreach ($data_save as $data) {

      $allocation = Allocation::where('vendor_id', $vendor_id)
      ->where('ticket_id', $data['ticket_id'])
      ->where('date', $data['date'])
      ->first();

      if ($allocation) {
        // Update record yang ada
        if ($data['type'] === "availability") {
          $allocation->availability = $value;
        }

        if ($data['type'] === "price") {
          // Decode JSON rateplans
          $rateplans = $allocation->rateplans ?? []; // Pastikan selalu array

          $found = false;
          foreach ($rateplans as &$rateplan) {
            if ($rateplan['rateplan'] == $data['rateplan_id']) {
              $rateplan['fixed_price'] = $value;
              $found = true;
              break;
            }
          }

          // Jika tidak ditemukan, tambahkan rateplan baru
          if (!$found) {
            $rateplans[] = [
            'rateplan' => $data['rateplan_id'],
            'fixed_price' => $value,
            ];
          }

          // Simpan kembali rateplans
          $allocation->rateplans = $rateplans;
        }

        $allocation->updated_at = $dateNow;
        $allocation->save();

      } else {
        // Buat record baru jika tidak ada
        $newAllocation = new Allocation();
        $newAllocation->vendor_id = $vendor_id;
        $newAllocation->ticket_id = $data['ticket_id'];
        $newAllocation->date = $data['date'];

        if ($data['type'] === "availability") {
          $newAllocation->availability = $value;
        }

        if ($data['type'] === "price") {
          $newAllocation->rateplans = [
          [
          'rateplan' => $data['rateplan_id'],
          'fixed_price' => $value,
          ]
          ];
        }

        $newAllocation->created_at = $dateNow;
        $newAllocation->updated_at = $dateNow;
        $newAllocation->save();
      }
    }

    if ($month) {
      // Redirect ke URL yang sama dengan parameter bulan tetap
      return redirect()->to('https://main.tiketxplorer.com/allocation?month=' . $month);
    } else {
      // Refresh page to reflect changes
      return redirect()->refresh();
    }
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $vendor_id = Input::post('vendor_id');
    $type2 = Input::post('type2');
    $optionrate1 = Input::post('optionrate1');
    $optionrate2 = Input::post('optionrate2');
    $value2 = Input::post('value2'); 

    // Decode JSON data dari 'data_save'
    $dates2 = json_decode(Input::post('dates2'), true);
    $data_save2 = json_decode(Input::post('data_save2'), true);

    // Loop melalui data untuk update alokasi
    foreach ($data_save2 as $data) {
      foreach ($dates2 as $dateRange) {
        $startDate = new DateTime($dateRange['start_date']);
        $endDate = new DateTime($dateRange['end_date']);
        $endDate->modify('+1 day'); // Tambahkan satu hari agar termasuk tanggal akhir

        // Loop melalui semua tanggal dari start_date sampai end_date
        for ($date = $startDate; $date < $endDate; $date->modify('+1 day')) {
          $currentDate = $date->format('Y-m-d');

          $allocation = Allocation::where('vendor_id', $vendor_id)
          ->where('ticket_id', $data['ticket_id'])
          ->where('date', $currentDate)
          ->first();

          if (!$allocation) {
            // Jika tidak ada, buat alokasi baru
            $allocation = new Allocation();
            $allocation->vendor_id = $vendor_id;
            $allocation->ticket_id = $data['ticket_id'];
            $allocation->date = $currentDate;
          }

          // Update allocation berdasarkan tipe
          if ($data['type'] === "availability") {
            $allocation->availability = $value2;
          } elseif ($data['type'] === "price") {
            $allocation->rateplans = $this->updateRateplans(
            $allocation->rateplans ?? [],
            $data['rateplan_id'],
            $optionrate1,
            $optionrate2,
            $value2,
            $vendor_id,
            $data['ticket_id']
            );
          }

          $allocation->updated_at = $dateNow;
          $allocation->save();
        }
      }
    }

    // Ambil bulan dari URL atau default jika tidak ada
    $month = Input::get('month', date('m-Y'));

    if ($month) {
      // Redirect ke URL yang sama dengan parameter bulan tetap
      return redirect()->to('https://main.tiketxplorer.com/allocation?month=' . $month);
    } else {
      // Refresh page to reflect changes
      return redirect()->refresh();
    }
  }

  /**
  * Update rateplans berdasarkan tipe operasi.
  */
  private function updateRateplans($rateplans, $rateplan_id, $optionrate1, $optionrate2, $value2, $vendor_id, $ticket_id)
  {
    $found = false;
    $datarateplan = Rateplan::where('vendor_id', $vendor_id)
    ->where('ticket_id', $ticket_id)
    ->where('id', $rateplan_id)
    ->first();

    foreach ($rateplans as &$rateplan) {
      if ($rateplan['rateplan'] == $rateplan_id) {
        // Jika ditemukan, update fixed_price
        $found = true;

        if ($optionrate1 === "set") {
          $rateplan['fixed_price'] = $value2;
        } elseif ($optionrate1 === "increase") {
          if ($optionrate2 === "amount") {
            $rateplan['fixed_price'] += $value2;
          } elseif ($optionrate2 === "percentage") {
            $rateplan['fixed_price'] += ($rateplan['fixed_price'] * $value2 / 100);
          }
        } elseif ($optionrate1 === "decrease") {
          if ($optionrate2 === "amount") {
            $rateplan['fixed_price'] -= $value2;
          } elseif ($optionrate2 === "percentage") {
            $rateplan['fixed_price'] -= ($rateplan['fixed_price'] * $value2 / 100);
          }
        }

        // Pastikan fixed_price tidak negatif
        $rateplan['fixed_price'] = max(0, $rateplan['fixed_price']);
        break;
      }
    }

    if (!$found) {
      // Jika rateplan tidak ditemukan, tambahkan baru
      $newPrice = $datarateplan ? $datarateplan['fixed_price'] : 0;

      if ($optionrate1 === "set") {
        $newPrice = $value2;
      } elseif ($optionrate1 === "increase") {
        if ($optionrate2 === "amount") {
          $newPrice += $value2;
        } elseif ($optionrate2 === "percentage") {
          $newPrice += ($newPrice * $value2 / 100);
        }
      } elseif ($optionrate1 === "decrease") {
        if ($optionrate2 === "amount") {
          $newPrice -= $value2;
        } elseif ($optionrate2 === "percentage") {
          $newPrice -= ($newPrice * $value2 / 100);
        }
      }

      $rateplans[] = [
      'rateplan' => $rateplan_id,
      'fixed_price' => max(0, $newPrice),
      ];
    }

    return $rateplans;
  }
}
