<?php 
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Blog;
use Yuren\BaliTiket\Models\Addon;
use Winter\Storm\Auth\AuthManager;
class Cms6736fcb56567e358939087_ddc9fc935d437d3f7afebba7d51eb632Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['addons'] = Addon::where('vendor_id', $user->vendor)->get();

      $this['blogs'] = Blog::orderBy('created_at', 'desc')->where('published', 1)->get();
    } 

    $this['ticket'] = Ticket::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = new Ticket();
    $query->vendor_id = Input::get('vendor');
    $query->blog_id = Input::get('blog');
    $query->name = Input::get('name');
    $query->slug = Input::get('slug');
    $query->description = Input::get('description');
    $query->short_desc = Input::get('short_desc');
    $query->highlight = Input::get('highlight');
    $query->start_time = Input::get('start_time');
    $query->end_time = Input::get('end_time');
    $query->cancellation = Input::get('cancellation');
    $query->terms = Input::get('terms');
    $query->availability = Input::get('availability');
    $query->images = Input::file('images');
    $query->other_img = Input::file('other_img');
    $query->created_at = $dateNow;
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    //addon
    $addons = Input::get('Ticket')['addons'];
    $formattedAddons = [];
    foreach ($addons as $addon) {
      $formattedAddons[] = ['addon' => $addon['addon'], 'type' => $addon['type'], 'cost' => $addon['cost']];
    }
    $query->addons = $formattedAddons;

    //inclusion
    $items = Input::get('Ticket')['inclusion'];
    $formattedItems = [];
    foreach ($items as $item) {
      $formattedItems[] = ['item' => $item['item']];
    }
    $query->inclusion = $formattedItems;

    //facilities
    $names = Input::get('Ticket')['facilities'];
    $formattedItems = [];
    foreach ($names as $name) {
      $formattedItems[] = ['name' => $name['name']];
    }
    $query->facilities = $formattedItems;

    $location = [
    'address' => Input::get('address'),
    'address_link' => Input::get('address_link')
    ];
    $query->location = $location;

    $query->save();

    // Set flash message
    Session::flash('success', 'Ticket has been added successfully.');

    // Redirect to the product page
    return redirect('/ticket');
  }
}
