<?php 
use Yuren\BaliTiket\Models\Product;
use Yuren\BaliTiket\Models\Vendor;
use Winter\Storm\Auth\AuthManager;
class Cms66f28be7787ab683316040_fec82c5bf740f0c4f5d577fc291ebf6aClass extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();

      $this['products'] = Product::orderBy('created_at', 'desc')->where('vendor_id', $user->vendor)->get();
    } 

    $this['product'] = Product::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = new Product();
    $query->vendor_id = Input::get('vendor');
    $query->name = Input::get('name');
    $query->slug = Input::get('slug');
    $query->description = Input::get('description');
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    $query->highlight = Input::get('highlight');

    $items = Input::get('Product')['inclusion'];
    // Mengubah array menjadi format yang diinginkan
    $formattedItems = [];
    foreach ($items as $item) {
      $formattedItems[] = ['item' => $item['item']];
    }
    $query->inclusion = $formattedItems;
    
    $query->type = Input::get('type');
    $query->short_desc = Input::get('short_desc');
    $query->category = Input::get('category');
    $query->link_url = Input::get('link_url');
    $query->link_address = Input::get('link_address');
    $query->address = Input::get('address');
    $query->images = Input::file('images');
    $query->facilities = Input::file('facilities');
    $query->map = Input::file('map');
    $query->created_at = $dateNow;

    $query->save();

    // Set flash message
    Session::flash('success', 'Product has been added successfully.');

    // Redirect to the product page
    return redirect('/product');
  }
}
