<?php 
use Yuren\BaliTiket\Models\Location;
use Yuren\BaliTiket\Models\Vendor;
use Winter\Storm\Auth\AuthManager;
class Cms6711ff0d6869a002666860_26930e3bd929935d720a2c1eca1ab371Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['locations'] = Location::orderBy('created_at', 'desc')->get();
    } 

    $this['location'] = Location::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = new Location();
    $query->name = Input::get('name');
    $query->slug = Input::get('slug');
    $query->description = Input::get('description');
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    $query->map_area_link = Input::get('map_area_link');
    $query->main_img = Input::file('main_img');
    $query->other_img = Input::file('other_img');
    $query->created_at = $dateNow;

    $query->save();

    // Set flash message
    Session::flash('success', 'Location has been added successfully.');

    // Redirect to the location page
    return redirect('/location');
  }
}
