<?php 
use Yuren\BaliTiket\Models\Blog;
use Yuren\BaliTiket\Models\Category;
use Yuren\BaliTiket\Models\Location;
use Winter\Storm\Auth\AuthManager;
class Cms6705f836136c4453374082_a6769b4d074c3437f49d091f55e234a5Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['blogs'] = Blog::orderBy('created_at', 'desc')->get();

      $this['category'] = Category::orderBy('created_at', 'desc')->get();

      $this['location'] = Location::orderBy('created_at', 'desc')->get();
    } 

    $this['blog'] = Blog::make();
  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = new Blog();
    $query->location_id = Input::get('location');
    $query->activity_id = Input::get('activity_id');
    $query->title = Input::get('title');
    $query->slug = Input::get('slug');
    $query->age_requirements = Input::get('age_requirements');
    $query->duration = Input::get('duration');
    $query->description = Input::get('description');
    $query->highlight = Input::get('highlight');
    $query->category = Input::get('category');
    $query->images = Input::file('images');
    $query->other_img = Input::file('other_img');
    $query->created_at = $dateNow;
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    //guides
    if(Input::get('guides') == 'on'){
      $query->guides = 1;
    } else {
      $query->guides = 0;
    }

    //lunch
    if(Input::get('lunch') == 'on'){
      $query->lunch = 1;
    } else {
      $query->lunch = 0;
    }

    $lists = Input::get('Blog')['inclusion'];
    // Mengubah array menjadi format yang diinginkan
    $formattedItems = [];
    foreach ($lists as $list) {
      $formattedItems[] = ['list' => $list['list']];
    }
    $query->inclusion = $formattedItems;

    $names = Input::get('Blog')['facilities'];
    // Mengubah array menjadi format yang diinginkan
    $formattedItems = [];
    foreach ($names as $name) {
      $formattedItems[] = ['name' => $name['name']];
    }
    $query->facilities = $formattedItems;    

    $query->save();

    // Set flash message
    Session::flash('success', 'Blog has been added successfully.');

    // Redirect to the blog page
    return redirect('/blog');
  }
}
