<?php 
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Addon;
use Winter\Storm\Auth\AuthManager;
class Cms6735c5a44db82090893530_8740138bc2df3efed9b9407ba1c97392Class extends Cms\Classes\PageCode
{
public function onStart()
  {
    $user = Auth::getUser();
    if ($user) {
      $this['vendor'] = $user->vendor;

      $this['vendors'] = Vendor::where('id', $user->vendor)->first();
    } 

  }
public function onSave()
  {
    date_default_timezone_set('Asia/Singapore');
    $dateNow = date('Y-m-d H:i:s');

    $query = new Addon();
    $query->name = Input::get('name');
    $query->description = Input::get('description');
    $query->vendor_id = Input::get('vendor_id');
    
    //published
    if(Input::get('published') == 'on'){
      $query->published = 1;
    } else {
      $query->published = 0;
    }

    $query->created_at = $dateNow;

    $query->save();

    // Set flash message
    Session::flash('success', 'Add On has been added successfully.');

    // Redirect to the location page
    return redirect('/addon');
  }
}
