<?php 
use Yuren\BaliTiket\Models\Bookings;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Guestlist;
use Winter\Storm\Auth\AuthManager;
use Carbon\Carbon;
class Cms6789af83aeae9395395904_7ba50e3c294bd763dd4c9d871703f7caClass extends Cms\Classes\PageCode
{
public function onStart()
    {
        date_default_timezone_set('Asia/Singapore');
        $dateNow = date('Y-m-d'); // Formatkan tanggal sekarang
        $this['dateNow'] = $dateNow;
        $yesterday = date('Y-m-d', strtotime('-1 day'));
        $this['yesterday'] = date('Y-m-d', strtotime('-1 day'));

        $user = Auth::getUser();
        if ($user) {
            $this['user'] = $user;

            // Ambil vendor berdasarkan user
            $this['vendors'] = Vendor::where('id', $user->vendor)->first();

            // Ambil semua booking dengan status pembayaran "paid"
            $this['booking'] = Bookings::where('status_payment', 'paid')->get();

            // Ambil nilai filter tanggal dari input (jika ada)
            $date_filter = Input::get('date_filter');
            $date_from = Input::get('from');
            $date_to = Input::get('to');
            $view_by = Input::get('view_by');

            // Jika tidak ada filter yang diberikan, isi date_filter dengan hari ini
            if (!$date_filter && !$date_from && !$date_to) {
                $date_filter = $dateNow;
            }

            // Simpan nilai filter untuk digunakan di view
            $this['date_filter'] = $date_filter;
            $this['from'] = $date_from;
            $this['to'] = $date_to;
            $this['view_by'] = $view_by;

            // Default: Tampilkan data berdasarkan filter yang diberikan atau hari ini
            $query = Guestlist::orderBy('datetime', 'desc');
            $queryBooking = Bookings::where('status_payment', 'paid')->orderBy('no_invoice', 'desc');
            $queryguestCount = Bookings::where('status_payment', 'paid');
            $queryguestCheckinCount = Guestlist::orderBy('no_invoice', 'asc');

            if ($date_filter) {
                if ($date_filter == 'today'){
                    $query->whereRaw('DATE(datetime) = ?', [$dateNow]);
                    $queryBooking->whereRaw('DATE(arrival_date) = ?', [$dateNow]);
                    $queryguestCount->whereRaw('DATE(arrival_date) = ?', [$dateNow]);
                    $queryguestCheckinCount->whereRaw('DATE(datetime) = ?', [$dateNow]);
                    $this['date_choice'] = date('d, F Y');
                } elseif ($date_filter == 'yesterday'){
                    $query->whereRaw('DATE(datetime) = ?', [$yesterday]);
                    $queryBooking->whereRaw('DATE(arrival_date) = ?', [$yesterday]);
                    $queryguestCount->whereRaw('DATE(arrival_date) = ?', [$yesterday]);
                    $queryguestCheckinCount->whereRaw('DATE(datetime) = ?', [$yesterday]);
                    $this['date_choice'] = date('d, F Y', strtotime('-1 day'));
                } elseif ($date_filter == 'date-range'){
                    if ($date_from) {
                        $query->whereRaw('DATE(datetime) BETWEEN ? AND ?', [$date_from, $date_to]);
                        $queryBooking->whereRaw('DATE(arrival_date) BETWEEN ? AND ?', [$date_from, $date_to]);
                        $queryguestCount->whereRaw('DATE(arrival_date) BETWEEN ? AND ?', [$date_from, $date_to]);
                        $queryguestCheckinCount->whereRaw('DATE(datetime) BETWEEN ? AND ?', [$date_from, $date_to]);
                        $this['date_choice'] = date('d, F Y', strtotime($date_from)) . ' - ' . date('d, F Y', strtotime($date_to));
                    }
                }
            }

            // Eksekusi query
            $this['guests'] = $query->get();
            $this['bookings'] = $queryBooking->get();
            $this['guestCount'] = $queryguestCount->sum('person');
            $this['guestCheckinCount'] = $queryguestCheckinCount->count();

        }
    }
}
