<?php 
use Yuren\BaliTiket\Models\Bookings;
use Yuren\BaliTiket\Models\Guestlist;
class Cms67775234d83f3029475927_a906ae6447c898e92d1417e1136efd92Class extends Cms\Classes\PageCode
{
public function onStart()
    {
        date_default_timezone_set('Asia/Singapore');
        $dateNow = date('Y-m-d H:i:s');
        $dateNow2 = date('Y-m-d');

        $bookingid = $this->param('bookingid');
        $barcode = Input::get('barcode');

        // Cari booking berdasarkan no_invoice
        $booking = Bookings::where('no_invoice', $bookingid)->whereRaw('DATE(arrival_date) = ?', [$dateNow2])->first();

        if ($booking) {
            // Cek apakah barcode file ada di folder bali_tiket/barcode
            $barcodePath = base_path("bali_tiket/barcode/{$barcode}.png");
            if (file_exists($barcodePath)) {
                // Hapus file barcode
                unlink($barcodePath);
            } else {
                // Redirect dengan pesan tiket sudah digunakan
                Flash::error('Ticket has already been used.');
                return redirect('/officer/check-in');
            }

            // Hitung jumlah guest dengan no_invoice yang sama
            $guestCount = Guestlist::where('no_invoice', $bookingid)->count();

            if ($guestCount < $booking->person) {
                // Tambahkan guest ke guestlist
                $query = new Guestlist();
                $query->no_invoice = $booking->no_invoice;
                $query->name = $booking->firstname;
                $query->ticket_id = $booking->ticket_id;
                $query->vendor_id = $booking->vendor_id;
                $query->datetime = $dateNow;

                $query->save();

                // Redirect dengan pesan valid ticket
                Flash::success('Valid ticket.');
                return redirect('/officer/check-in');
            }
        }

        // Redirect dengan pesan unvalid ticket jika kondisi tidak terpenuhi
        Flash::error('Invalid ticket.');
        return redirect('/officer/check-in');
    }
}
