<?php namespace Yuren\BaliTiket\Updates;

use Schema;
use Winter\Storm\Database\Updates\Migration;

class BuilderTableUpdateYurenBalitiketGuests6 extends Migration
{
    public function up()
    {
        Schema::table('yuren_balitiket_guests', function($table)
        {
            $table->text('google_id')->nullable();
            $table->text('facebook_id')->nullable();
            $table->text('apple_id')->nullable();
            $table->text('username')->nullable()->change();
            $table->text('phone')->nullable()->change();
            $table->text('platform')->nullable(false)->default('null')->change();
            $table->text('country')->nullable()->change();
        });
    }
    
    public function down()
    {
        Schema::table('yuren_balitiket_guests', function($table)
        {
            $table->dropColumn('google_id');
            $table->dropColumn('facebook_id');
            $table->dropColumn('apple_id');
            $table->text('username')->nullable(false)->change();
            $table->text('phone')->nullable(false)->change();
            $table->text('platform')->nullable()->default(null)->change();
            $table->text('country')->nullable(false)->change();
        });
    }
}
