<?php namespace Yuren\BaliTiket\Updates;

use Schema;
use Winter\Storm\Database\Updates\Migration;

class BuilderTableDeleteYurenBalitiketProducts extends Migration
{
    public function up()
    {
        Schema::dropIfExists('yuren_balitiket_products');
    }
    
    public function down()
    {
        Schema::create('yuren_balitiket_products', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id')->unsigned();
            $table->integer('vendor_id');
            $table->text('name');
            $table->text('slug')->nullable();
            $table->text('description')->nullable();
            $table->text('published');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
            $table->text('highlight')->nullable();
            $table->text('address')->nullable();
            $table->text('inclusion')->nullable();
            $table->text('link_address')->nullable();
            $table->text('type')->nullable();
            $table->integer('count_book')->nullable()->default(0);
            $table->text('short_desc')->nullable();
            $table->text('category')->nullable();
            $table->text('link_url')->nullable();
        });
    }
}
