<?php namespace Yuren\BaliTiket\Updates;

use Schema;
use Winter\Storm\Database\Updates\Migration;

class BuilderTableCreateYurenBalitiketUsers extends Migration
{
    public function up()
    {
        Schema::create('yuren_balitiket_users', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id')->unsigned();
            $table->text('firstname');
            $table->text('lastname');
            $table->text('username');
            $table->text('email');
            $table->text('phone');
            $table->text('password')->nullable();
            $table->text('token');
            $table->text('status');
            $table->text('platform');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('yuren_balitiket_users');
    }
}
