<?php namespace Yuren\BaliTiket\Updates;

use Schema;
use Winter\Storm\Database\Updates\Migration;

class BuilderTableCreateYurenBalitiketTickets extends Migration
{
    public function up()
    {
        Schema::create('yuren_balitiket_tickets', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id')->unsigned();
            $table->text('name');
            $table->text('slug')->nullable();
            $table->text('description')->nullable();
            $table->text('inclusion')->nullable();
            $table->text('exclusion')->nullable();
            $table->text('price');
            $table->integer('product_id');
            $table->text('published');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('yuren_balitiket_tickets');
    }
}
