<?php namespace Yuren\BaliTiket\Updates;

use Schema;
use Winter\Storm\Database\Updates\Migration;

class BuilderTableCreateYurenBalitiketBookings extends Migration
{
    public function up()
    {
        Schema::create('yuren_balitiket_bookings', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id')->unsigned();
            $table->text('firstname');
            $table->text('lastname');
            $table->text('name');
            $table->text('email');
            $table->text('phone');
            $table->text('country');
            $table->text('state')->nullable();
            $table->text('city')->nullable();
            $table->text('no_invoice');
            $table->text('invoice_date');
            $table->text('total');
            $table->text('status_payment');
            $table->text('ticket');
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('yuren_balitiket_bookings');
    }
}
