<?php namespace Yuren\BaliTiket\Updates;

use Schema;
use Winter\Storm\Database\Updates\Migration;

class BuilderTableCreateYurenBalitiketBlog extends Migration
{
    public function up()
    {
        Schema::create('yuren_balitiket_blog', function($table)
        {
            $table->engine = 'InnoDB';
            $table->increments('id')->unsigned();
            $table->text('title')->nullable();
            $table->text('slug')->nullable();
            $table->text('description')->nullable();
            $table->text('short_desc')->nullable();
            $table->text('duration')->nullable();
            $table->text('guides')->nullable();
            $table->text('lunch')->nullable();
            $table->text('age_terms')->nullable();
            $table->text('highlight')->nullable();
            $table->text('facilities')->nullable();
            $table->text('inclusion')->nullable();
            $table->integer('activity_id')->nullable();
            $table->integer('location_id')->nullable();
            $table->text('published')->nullable();
            $table->timestamp('created_at')->nullable();
            $table->timestamp('updated_at')->nullable();
        });
    }
    
    public function down()
    {
        Schema::dropIfExists('yuren_balitiket_blog');
    }
}
