<?php

use Yuren\BaliTiket\Resources\GuestAuth;
use Yuren\BaliTiket\Resources\BookingResources;
use Yuren\BaliTiket\Resources\TicketResources;
use Yuren\BaliTiket\Resources\BlogResources;
use Yuren\BaliTiket\Resources\LocationResources;
use Yuren\BaliTiket\Resources\CategoryResources;
use Yuren\BaliTiket\Resources\ReportResources;

use Yuren\BaliTiket\Middleware\JWTMiddleware;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;
use Illuminate\Support\Facades\Validator;

use System\Models\File;

// API V2
Route::prefix('api/v2/')->group(function (){
    // API Category
    Route::get('get-nav-category', 'Yuren\BaliTiket\Resources\CategoryResources@getNavCategory');
    Route::get('get-home-main-category', 'Yuren\BaliTiket\Resources\CategoryResources@getHomeMainCategory');
    Route::get('get-home-category', 'Yuren\BaliTiket\Resources\CategoryResources@getHomeCategory');
    Route::get('get-list-category', 'Yuren\BaliTiket\Resources\CategoryResources@getListCategory');
    // End API Category

    // API blog
    Route::get('get-home-blog', 'Yuren\BaliTiket\Resources\BlogResources@getHomeBlog');
    Route::get('get-home-blog-more', 'Yuren\BaliTiket\Resources\BlogResources@getHomeBlogMore');
    Route::get('get-detail-blog', 'Yuren\BaliTiket\Resources\BlogResources@getDetailBlog');
    Route::get('get-other-blog', 'Yuren\BaliTiket\Resources\BlogResources@getOtherBlog');
    Route::get('get-list-blog', 'Yuren\BaliTiket\Resources\BlogResources@getListBlog');
    // end API blog

    // API location
    Route::get('get-home-location', 'Yuren\BaliTiket\Resources\LocationResources@getHomeLocation');
    Route::get('get-list-location', 'Yuren\BaliTiket\Resources\LocationResources@getListLocation');
    Route::get('get-detail-location', 'Yuren\BaliTiket\Resources\LocationResources@getDetailLocation');
    Route::get('get-popular-blog-location', 'Yuren\BaliTiket\Resources\LocationResources@getPopularBlogLocation');
    Route::get('get-latest-blog-location', 'Yuren\BaliTiket\Resources\LocationResources@getLatestBlogLocation');
    Route::get('get-all-blog-location', 'Yuren\BaliTiket\Resources\LocationResources@getAllBlogLocation');
    // end API location

    // API ticket
    Route::get('get-list-ticket', 'Yuren\BaliTiket\Resources\TicketResources@getListTicket');
    Route::get('get-cheapest-price', 'Yuren\BaliTiket\Resources\TicketResources@getCheapestPrice');
    Route::get('get-detail-ticket', 'Yuren\BaliTiket\Resources\TicketResources@getDetailTicket');
    Route::get('ticket-check-availability', 'Yuren\BaliTiket\Resources\TicketResources@ticketCheckAvailability');
    Route::get('ticket-check-price', 'Yuren\BaliTiket\Resources\TicketResources@ticketCheckPrice');
    Route::get('get-form-ticket', 'Yuren\BaliTiket\Resources\TicketResources@getFormTicket');
    // end API ticket

    // API Booking
    Route::post('send-form', 'Yuren\BaliTiket\Resources\BookingResources@sendForm');
    // end API Booking

    // Report API
    Route::get('visitor', 'Yuren\BaliTiket\Resources\ReportResources@visitor');
    // end report API

    // Search API
    Route::get('search', 'Yuren\BaliTiket\Resources\BlogResources@searchBlogLocation');
    // end Search API

    // Guests API
    Route::post('guest-login', 'Yuren\BaliTiket\Resources\GuestAuth@login');
    Route::post('guest-other-login', 'Yuren\BaliTiket\Resources\GuestAuth@otherLogin');
    Route::post('guest-register', 'Yuren\BaliTiket\Resources\GuestAuth@register');
    Route::post('guest-other-register', 'Yuren\BaliTiket\Resources\GuestAuth@otherRegister');

    Route::group(['middleware' => [Yuren\BaliTiket\Middleware\JWTMiddleware::class]], function () {
        Route::get('guest-profile', 'Yuren\BaliTiket\Resources\GuestAuth@profile');
        Route::post('guest-edit-profile', 'Yuren\BaliTiket\Resources\GuestAuth@editProfile');
        Route::get('guest-booking-history', 'Yuren\BaliTiket\Resources\BookingResources@bookingHistory');
    }); 
    // end Guests API
});

?>