<?php namespace Yuren\BaliTiket\Resources;

use Backend\Classes\Controller;

use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Allocation;
use Yuren\BaliTiket\Models\Rateplan;
use Yuren\BaliTiket\Models\Addon;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;

class TicketResources extends Controller
{
    public function getListTicket(Request $request)
    {
        // Ambil data dengan paginasi
        $perPage = Input::get('items', 10);
        $blog_id = Input::get('blog_id');

        $ticket = Ticket::with(['images', 'other_img', 'blog', 'vendor'])
        ->where('published', 1)
        ->where('blog_id', $blog_id)
        ->orderBy('view', 'desc')
        ->paginate($perPage);

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $ticket->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $ticket->total(),
                'items_per_page' => $ticket->perPage(),
                'current_page' => $ticket->currentPage(),
                'total_pages' => $ticket->lastPage(),
            ]
        ]);
    }

    public function getCheapestPrice(Request $request)
    {
        // Ambil parameter ticket_id dari request
        $ticket_id = $request->input('ticket_id');

        // Ambil data rateplan dengan relasi dan kondisi yang sesuai
        $rateplans = Rateplan::with(['ticket', 'vendor'])
        ->where('published', 1)
        ->where('ticket_id', $ticket_id)
        ->get();

        // Cek apakah ada rateplan yang ditemukan
        if ($rateplans->isEmpty()) {
            return response()->json([
                'status' => 'error',
                'message' => 'No rateplan found for the given ticket_id',
                'data' => null,
            ]);
        }

        // Dapatkan harga terendah
        $cheapest_price = $rateplans->min('fixed_price');

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Cheapest price retrieved successfully',
            'data' => $cheapest_price,
        ]);
    }

    public function getDetailTicket(Request $request)
    {
        $ticket_id = Input::get('ticket_id');
        $blog_id = Input::get('blog_id');
        $vendor_id = Input::get('vendor_id');

        $data = Ticket::with(['images', 'other_img', 'blog', 'vendor'])
        ->where('id', $ticket_id)
        ->where('blog_id', $blog_id)
        ->where('vendor_id', $vendor_id)
        ->first();

        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $data
        ]);
    }

    public function ticketCheckAvailability(Request $request)
    {
        $vendor_id = Input::get('vendor_id');
        $ticket_id = Input::get('ticket_id');
        $date = Input::get('date');

        $allocation = Allocation::where('vendor_id', $vendor_id)
        ->where('ticket_id', $ticket_id)
        ->whereDate('date', $date) 
        ->whereNotNull('availability')
        ->first();

        if ($allocation) {
            return $allocation->availability;
        }

        $ticket = Ticket::find($ticket_id);

        return $ticket ? $ticket->availability : null;
    }

    public function ticketCheckPrice(Request $request)
    {
        $vendor_id = Input::get('vendor_id');
        $ticket_id = Input::get('ticket_id');
        $rateplan_id = Input::get('rateplan_id');
        $date = Input::get('date');

        $allocation = Allocation::where('vendor_id', $vendor_id)
        ->where('ticket_id', $ticket_id)
        ->whereDate('date', $date)
        ->first();

        if ($allocation && isset($allocation['rateplans'])) {
            foreach ($allocation['rateplans'] as $rateplan) {
                if ($rateplan['rateplan'] == $rateplan_id) {
                    if (!is_null($rateplan['fixed_price'])) {
                        return $rateplan['fixed_price'];
                    }
                }
            }
        }

        $rateplan = Rateplan::find($rateplan_id);

        return $rateplan ? $rateplan->fixed_price : null;
    }

    public function getFormTicket(Request $request)
    {
        // Mengambil input dari query string
        $ticket_id = $request->input('ticket_id');
        $blog_id = $request->input('blog_id');
        $vendor_id = $request->input('vendor_id');
        $date = $request->input('date');

        // Validasi input
        if (!$ticket_id || !$blog_id || !$vendor_id || !$date) {
            return response()->json([
                'status' => 'error',
                'message' => 'Missing required parameters',
                'data' => null,
            ], 400);
        }

        // Cek allocation berdasarkan parameter
        $allocation = Allocation::where('vendor_id', $vendor_id)
        ->where('ticket_id', $ticket_id)
        ->whereDate('date', $date)
        ->first();

        if ($allocation) {
            // Ambil detail ticket
            $dataticket = Ticket::with(['images', 'other_img', 'blog', 'vendor'])
            ->where('id', $ticket_id)
            ->where('blog_id', $blog_id)
            ->where('vendor_id', $vendor_id)
            ->first();

            $checkavailability = 0;
            if ($allocation['availability'] != null){
                $checkavailability = $allocation['availability'];
            } else {
                $checkavailability = $dataticket['availability'];
            }

            // Ambil rateplan dari allocation dan update fixed_price
            $datarateplan = [];
            $listrateplan = Rateplan::where('ticket_id', $ticket_id)
            ->where('vendor_id', $vendor_id)
            ->where('published', 1)
            ->select('id', 'name', 'min_purchase', 'max_purchase', 'fixed_price')
            ->get();

            foreach ($listrateplan as $rateplan) {
                $allocation_rateplan = collect($allocation->rateplans)->firstWhere('rateplan', $rateplan->id);
                if ($allocation_rateplan) {
                    $rateplan->fixed_price = (float) $allocation_rateplan['fixed_price'];
                } else {
                    $rateplan->fixed_price = (float) $rateplan->fixed_price;
                }
                $datarateplan[] = $rateplan;
            }

            $dataaddon = [];

            foreach ($dataticket['addons'] as $ticketaddon) {
                $addon = Addon::where('id', $ticketaddon['addon'])->first();
                $dataaddon[] = [
                    'addon_id' => (int)$ticketaddon['addon'],
                    'name' => $addon['name'],
                    'type' => $ticketaddon['type'],
                    'cost' => $ticketaddon['cost']
                ];
            }

            $data = [
                'ticket' => $dataticket,
                'rateplan' => $datarateplan,
                'addon' => $dataaddon,
                'availability' => $checkavailability
            ];
        } else {
            // Jika allocation tidak ditemukan
            $dataticket = Ticket::with(['images', 'other_img', 'blog', 'vendor'])
            ->where('id', $ticket_id)
            ->where('blog_id', $blog_id)
            ->where('vendor_id', $vendor_id)
            ->first();

            $checkavailability =  $dataticket['availability'];

            // Ambil rateplan yang diterbitkan dan pastikan fixed_price numerik
            $datarateplan = Rateplan::where('ticket_id', $ticket_id)
            ->where('vendor_id', $vendor_id)
            ->where('published', 1)
            ->select('id', 'name', 'min_purchase', 'max_purchase', 'fixed_price')
            ->get();

            $dataaddon = [];

            foreach ($dataticket['addons'] as $ticketaddon) {
                $addon = Addon::where('id', $ticketaddon['addon'])->first();
                $dataaddon[] = [
                    'addon_id' => (int)$ticketaddon['addon'],
                    'name' => $addon['name'],
                    'type' => $ticketaddon['type'],
                    'cost' => $ticketaddon['cost']
                ];
            }

            $data = [
                'ticket' => $dataticket,
                'rateplan' => $datarateplan,
                'addon' => $dataaddon,
                'availability' => $checkavailability
            ];
        }

        // Kembalikan respons JSON
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $data,
        ]);
    }
}