<?php namespace Yuren\BaliTiket\Resources;

use Backend\Classes\Controller;

use Yuren\BaliTiket\Models\Country;
use Yuren\BaliTiket\Models\Tracking;
use Yuren\BaliTiket\Models\Os;
use Yuren\BaliTiket\Models\Browser;
use Yuren\BaliTiket\Models\Device;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;

class ReportResources extends Controller
{
    public function visitor(Request $request)
    {
        $vendor = Input::get('vendor');
        $ip_address = Input::get('ip_address');
        $country = Input::get('country');
        $device = Input::get('device');
        $os = Input::get('os');
        $browser = Input::get('browser');
        $url = Input::get('url');
        $title = Input::get('title');

        date_default_timezone_set('Asia/Singapore');
        $dateNow = date('Y-m-d H:i:s');

        try {
            // Tracking
            $query_tracking = new Tracking();
            $query_tracking->vendor = $vendor;
            $query_tracking->ip_address = $ip_address;
            $query_tracking->url = $url;
            $query_tracking->title = $title;
            $query_tracking->created_at = $dateNow;
            $query_tracking->save();

            // Country
            $query_country = new Country();
            $query_country->vendor = $vendor;
            $query_country->ip_address = $ip_address;
            $query_country->country = $country;
            $query_country->created_at = $dateNow;
            $query_country->save();

            // OS
            $query_os = new Os();
            $query_os->vendor = $vendor;
            $query_os->ip_address = $ip_address;
            $query_os->os = $os;
            $query_os->created_at = $dateNow;
            $query_os->save();

            // Device
            $query_device = new Device();
            $query_device->vendor = $vendor;
            $query_device->ip_address = $ip_address;
            $query_device->device = $device;
            $query_device->created_at = $dateNow;
            $query_device->save();

            // Browser
            $query_browser = new Browser();
            $query_browser->vendor = $vendor;
            $query_browser->ip_address = $ip_address;
            $query_browser->browser = $browser;
            $query_browser->created_at = $dateNow;
            $query_browser->save();

            // Return success response
            return Response::json([
                'status' => 'success',
                'message' => 'Data has been saved successfully',
            ], 200);
        } catch (\Exception $e) {
            // Return error response
            return Response::json([
                'status' => 'error',
                'message' => 'There was an error saving the data',
                'error' => $e->getMessage(),
            ], 500);
        }
    }        
}