<?php namespace Yuren\BaliTiket\Resources;

use Backend\Classes\Controller;

use Yuren\BaliTiket\Models\Location;
use Yuren\BaliTiket\Models\Blog;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;

class LocationResources extends Controller
{
    public function getHomeLocation(Request $request)
    {
        // Ambil data dengan paginasi
        $perPage = Input::get('items', 10);
        $location = Location::with('main_img')
        ->with('other_img')
        ->where('published', 1)
        ->orderBy('view', 'desc')
        ->paginate($perPage);

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $location->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $location->total(),
                'items_per_page' => $location->perPage(),
                'current_page' => $location->currentPage(),
                'total_pages' => $location->lastPage(),
            ]
        ]);
    }

    public function getListLocation(Request $request)
    {
        // Ambil data dengan paginasi
        $perPage = Input::get('items', 10);
        $location = Location::with('main_img')
        ->with('other_img')
        ->where('published', 1)
        ->orderBy('view', 'desc')
        ->paginate($perPage);

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $location->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $location->total(),
                'items_per_page' => $location->perPage(),
                'current_page' => $location->currentPage(),
                'total_pages' => $location->lastPage(),
            ]
        ]);
    }

    public function getDetailLocation(Request $request)
    {
        // Ambil data dengan paginasi
        $slug = Input::get('slug');

        $location = Location::with('main_img')
        ->with('other_img')
        ->where('published', 1)
        ->where('slug', $slug)
        ->first();

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $location, 
        ]);
    }

    public function getPopularBlogLocation(Request $request)
    {
        $area = Input::get('area');
        $perPage = Input::get('items', 10);

        $location_id = Location::where('name', $area)->select('id')->first();

        if ($area != null) {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->where('location_id', $location_id->id)
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        } else {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        }

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $blog->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $blog->total(),
                'items_per_page' => $blog->perPage(),
                'current_page' => $blog->currentPage(),
                'total_pages' => $blog->lastPage(),
            ]
        ]);
    }

    public function getLatestBlogLocation(Request $request)
    {
        $area = Input::get('area');
        $perPage = Input::get('items', 10);

        $location_id = Location::where('name', $area)->select('id')->first();

        if ($area != null) {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->where('location_id', $location_id->id)
            ->orderBy('created_at', 'desc')
            ->paginate($perPage);
        } else {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->orderBy('created_at', 'desc')
            ->paginate($perPage);
        }

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $blog->items(),
            'meta' => [
                'total_items' => $blog->total(),
                'items_per_page' => $blog->perPage(),
                'current_page' => $blog->currentPage(),
                'total_pages' => $blog->lastPage(),
            ]
        ]);
    }

    public function getAllBlogLocation(Request $request)
    {
        $area = Input::get('area');
        $perPage = Input::get('items', 10);

        $location_id = Location::where('name', $area)->select('id')->first();

        if ($area != null) {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->where('location_id', $location_id->id)
            ->paginate($perPage);
        } else {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->paginate($perPage);
        }

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $blog->items(),
            'meta' => [
                'total_items' => $blog->total(),
                'items_per_page' => $blog->perPage(),
                'current_page' => $blog->currentPage(),
                'total_pages' => $blog->lastPage(),
            ]
        ]);
    }       
}