<?php namespace Yuren\BaliTiket\Resources;

use Backend\Classes\Controller;
use Illuminate\Support\Facades\Validator;
use Yuren\BaliTiket\Models\Guests; // Model untuk user, buat sesuai kebutuhan
use Firebase\JWT\JWT;
use Illuminate\Http\Request;
use Firebase\JWT\Key;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Response;

class GuestAuth extends Controller
{
    private $key = "xMQsdLBGL4TInopMtedwSmLkQqYWIyWt"; // Kunci rahasia untuk JWT

    // Endpoint untuk login
    public function login(Request $request)
    {
        // Ambil data login (username dan password)
        $email = $request->input('email');
        $password = $request->input('password');

        // Validasi input
        $validator = Validator::make($request->all(), [
            'email' => 'required',
            'password' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => 'Invalid input'], 400);
        }

        // Verifikasi user dengan database (misalnya menggunakan User model)
        if ($email){
            $user = Guests::where('email', $email)->first();
        }

        if ($user && password_verify($password, $user->password)) {
            // Buat token JWT
            $payload = [
                'iss' => 'tiketxplorer.com', // Issuer
                'sub' => $user->id,  // User ID
                'iat' => time(),     // Waktu dibuat
                'exp' => time() + 3600, // Token kedaluwarsa dalam 1 jam
            ];

            $jwt = JWT::encode($payload, $this->key, 'HS256');

            return response()->json(['token' => $jwt], 200);
        } else {
            return response()->json(['error' => 'Invalid credentials'], 401);
        }
    }

    // Endpoint untuk registrasi
    public function register(Request $request)
    {
        // Validasi data
        $validator = Validator::make($request->all(), [
            'firstname' => 'required|string|max:255',
            'lastname' => 'required|string|max:255',
            'username' => 'required|string|max:255|unique:yuren_balitiket_guests,username',
            'email' => 'required|email|unique:yuren_balitiket_guests,email',
            'phone' => 'required|unique:yuren_balitiket_guests,phone',
            'password' => 'required|min:8',
            'country' => 'required|string|max:100',
        ]);
    
        // Periksa jika validasi gagal
        if ($validator->fails()) {
            return response()->json([
                'status' => 'error',
                'message' => $validator->errors(),
            ], 400);
        }

        $postData = [
            'firstname' => $request->input('firstname'),
            'email' => $request->input('email')
        ];

        // Lakukan pengiriman data menggunakan curl
        $ch = curl_init('https://main.tiketxplorer.com/bali_tiket/send_email_verification.php');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Mendapatkan status HTTP response
        $error = curl_error($ch);
        curl_close($ch);

        // Handle response dari API jika diperlukan
        if ($httpCode >= 200 && $httpCode < 300) {
            // Berhasil
            // Simpan data pengguna
            $user = new Guests();
            $user->firstname = $request->input('firstname');
            $user->lastname = $request->input('lastname');
            $user->username = $request->input('username');
            $user->email = $request->input('email');
            $user->phone = $request->input('phone');
            $user->country = $request->input('country');
            $user->password = Hash::make($request->input('password'));
            $user->platform = "Website";
            $user->save();
        
            return response()->json([
                'status' => 'success',
                'message' => 'User registered successfully!',
            ], 201);
        } else {
            // Gagal
            return response()->json(['message' => 'Failed to send data', 'http_code' => $httpCode, 'error' => $error]);
        }
    }

    // Endpoint untuk login
    public function otherLogin(Request $request)
    {
        $email = $request->input('email');
        $platform = $request->input('iss');
        $other_id = $request->input('sub');

        if ($platform == "https://accounts.google.com"){
            $user = Guests::where('email', $email)->where('google_id', $other_id)->first();
        }elseif ($platform == "https://accounts.meta.com"){
            $user = Guests::where('email', $email)->where('facebook_id', $other_id)->first();
        }

        if ($user) {
            // Buat token JWT
            $payload = [
                'iss' => 'tiketxplorer.com', // Issuer
                'sub' => $user->id,  // User ID
                'iat' => time(),     // Waktu dibuat
                'exp' => time() + 3600, // Token kedaluwarsa dalam 1 jam
            ];

            $jwt = JWT::encode($payload, $this->key, 'HS256');

            return response()->json(['token' => $jwt], 200);
        } else {
            return response()->json(['error' => 'Invalid credentials'], 401);
        }
    }

    public function otherRegister(Request $request)
    {
        // Ambil data dari payload
        $platform = $request->input('iss');
        $name = $request->input('name');
        $email = $request->input('email');
        $other_id = $request->input('sub');
        $password = Str::random(16);

        // Pisahkan nama berdasarkan spasi
        $parts = explode(' ', $name);
        $firstname = $parts[0] ?? '';
        $lastname = isset($parts[2]) ? implode(' ', array_slice($parts, 1)) : ($parts[1] ?? '');
        $username = isset($parts[1]) ? $parts[0] . $parts[1] : $parts[0];

        // Cek jika email atau username sudah ada
        $userExists = Guests::where('email', $email)->first();

        if ($userExists) {
            return response()->json(['status' => 'error', 'message' => 'Email or Username already exists.']);
        }

        // Buat user baru
        $user = new Guests();
        $user->firstname = $firstname;
        $user->lastname = $lastname;
        $user->username = $username;
        $user->email = $email;
        $user->password = Hash::make($password);

        // Tambahkan platform jika sumber berasal dari Google
        if ($platform === "https://accounts.google.com") {
            $user->platform = "Google";
            $user->google_id = $other_id;
            $user->verified = 1;
        }

        $user->save();

        // Buat token JWT
        $payload = [
            'iss' => 'tiketxplorer.com', // Issuer
            'sub' => $user->id,  // User ID
            'iat' => time(),     // Waktu dibuat
            'exp' => time() + 3600, // Token kedaluwarsa dalam 1 jam
        ];

        $jwt = JWT::encode($payload, $this->key, 'HS256');

        return response()->json([
            'status' => 'success',
            'message' => 'User registered successfully.',
            'token' => $jwt
        ],200);
        
    }

    public function profile(Request $request)
    {
         // Cek token
         $token = $request->bearerToken();

         if ($token) {
             try {
                // Verifikasi token menggunakan Key (metode baru di v6.x)
                $decoded = JWT::decode($token, new Key($this->key, 'HS256'));
                $payload = (array) $decoded;

                // Ambil user ID dari payload (sub biasanya digunakan untuk user ID)
                $userId = $payload['sub'] ?? null;

                if ($userId) {
                    // Cari user di database
                    $user = Guests::where('id', $userId)->with('photo')->first();
    
                    // Periksa apakah pengguna ditemukan dan password cocok
                    if ($user) {
                        return response()->json([
                            'status' => 'success',
                            'message' => 'Guest Profile Found',
                            'data' => $user,
                        ]);
                    } else {
                        return response()->json([
                            'status' => 'error',
                            'message' => 'User Not Found.',
                        ], 401);
                    }
                }
             } catch (\Exception $e) {
                return Response::json(['error' => 'Unauthorized', 'message' => $e->getMessage()], 401);
             }
         }
 
         return Response::json(['error' => 'No token provided'], 401);
    }

    public function editProfile(Request $request)
    {
        // Cek token
        $token = $request->bearerToken();

        if ($token) {
            try {
                // Verifikasi token menggunakan Key (metode baru di v6.x)
                $decoded = JWT::decode($token, new Key($this->key, 'HS256'));
                $payload = (array) $decoded;

                // Ambil user ID dari payload (sub biasanya digunakan untuk user ID)
                $userId = $payload['sub'] ?? null;

                if ($userId) {
                    // Cari user di database
                    $user = Guests::where('id', $userId)->first();

                    // Periksa apakah pengguna ditemukan
                    if ($user) {
                        // Validasi data
                        $validator = Validator::make($request->all(), [
                            'firstname' => 'required|string|max:255',
                            'lastname' => 'required|string|max:255',
                            'username' => 'required|string|max:255',
                            'email' => 'required|email',
                            'phone' => 'required',
                            'photo' => 'nullable|image|mimes:jpg,jpeg,png,webp|max:2048', // Validasi file gambar
                            'country' => 'required|string|max:100',
                        ]);

                        // Periksa jika validasi gagal
                        if ($validator->fails()) {
                            return response()->json([
                                'status' => 'error',
                                'message' => $validator->errors(),
                            ], 400);
                        }

                        // Perbarui data pengguna
                        $user->firstname = $request->input('firstname');
                        $user->lastname = $request->input('lastname');
                        $user->username = $request->input('username');
                        $user->email = $request->input('email');
                        $user->phone = $request->input('phone');
                        $user->country = $request->input('country');

                        // Jika ada file foto diunggah
                        if ($request->hasFile('photo')) {
                            $photo = $request->file('photo');

                            // Hapus foto lama jika ada
                            if ($user->photo) {
                                $user->photo->delete();
                            }

                            // Simpan foto baru menggunakan attachment Winter CMS
                            $file = new \System\Models\File();
                            $file->fromPost($photo);
                            $user->photo()->add($file);
                        }

                        $user->save();

                        return response()->json([
                            'status' => 'success',
                            'message' => 'Your profile has been updated.'
                        ]);
                    } else {
                        return response()->json([
                            'status' => 'error',
                            'message' => 'User Not Found.',
                        ], 401);
                    }
                }
            } catch (\Exception $e) {
                return Response::json(['error' => 'Unauthorized', 'message' => $e->getMessage()], 401);
            }
        }

        return Response::json(['error' => 'No token provided'], 401);
    }

    public function editPassword(Request $request)
    {
        // Cek token
        $token = $request->bearerToken();

        if ($token) {
            try {
                // Verifikasi token menggunakan Key (metode baru di v6.x)
                $decoded = JWT::decode($token, new Key($this->key, 'HS256'));
                $payload = (array) $decoded;

                // Ambil user ID dari payload (sub biasanya digunakan untuk user ID)
                $userId = $payload['sub'] ?? null;

                if ($userId) {
                    // Cari user di database
                    $user = Guests::where('id', $userId)->first();

                    // Periksa apakah pengguna ditemukan dan password cocok
                    if ($user) {
                        // Validasi data
                        $validator = Validator::make($request->all(), [
                            'password' => 'required|min:8',
                            'current_password' => 'required',
                        ]);
                    
                        // Periksa jika validasi gagal
                        if ($validator->fails()) {
                            return response()->json([
                                'status' => 'error',
                                'message' => $validator->errors(),
                            ], 400);
                        }

                        // Verifikasi apakah current password yang diberikan sesuai dengan password yang ada
                        if (!Hash::check($request->input('current_password'), $user->password)) {
                            return response()->json([
                                'status' => 'error',
                                'message' => 'Current password is incorrect.',
                            ], 400);
                        }

                        // Jika cocok, update password
                        $user->password = Hash::make($request->input('password'));
                        $user->save();

                        return response()->json([
                            'status' => 'success',
                            'message' => 'Your password has been updated.'
                        ]);
                    } else {
                        return response()->json([
                            'status' => 'error',
                            'message' => 'User Not Found.',
                        ], 401);
                    }
                }
            } catch (\Exception $e) {
                return Response::json(['error' => 'Unauthorized', 'message' => $e->getMessage()], 401);
            }
        }

        return Response::json(['error' => 'No token provided'], 401);
    }

}
