<?php namespace Yuren\BaliTiket\Resources;

use Backend\Classes\Controller;

use Yuren\BaliTiket\Models\Category;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;

class CategoryResources extends Controller
{
    public function getNavCategory(Request $request)
    {
        // Ambil data dengan paginasi
        $perPage = Input::get('items', 10);
        $categories = Category::with(['icon_mobile', 'icon_desktop', 'images'])
        ->where('main', 1)
        ->where('published', 1)
        ->orderBy('view', 'desc')
        ->paginate($perPage);

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $categories->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $categories->total(),
                'items_per_page' => $categories->perPage(),
                'current_page' => $categories->currentPage(),
                'total_pages' => $categories->lastPage(),
            ]
        ]);
    }

    public function getHomeMainCategory(Request $request)
    {
        // Ambil data dengan paginasi
        $perPage = Input::get('items', 10);
        $categories = Category::with(['icon_mobile', 'icon_desktop','images'])
        ->where('main', 1)
        ->where('published', 1)
        ->orderBy('view', 'desc')
        ->paginate($perPage);

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $categories->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $categories->total(),
                'items_per_page' => $categories->perPage(),
                'current_page' => $categories->currentPage(),
                'total_pages' => $categories->lastPage(),
            ]
        ]);
    }

    public function getHomeCategory(Request $request)
    {
        // Ambil data dengan paginasi
        $perPage = Input::get('items', 10);
        $categories = Category::with(['icon_mobile', 'icon_desktop', 'images'])
        ->where('published', 1)
        ->orderBy('view', 'desc')
        ->paginate($perPage);

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $categories->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $categories->total(),
                'items_per_page' => $categories->perPage(),
                'current_page' => $categories->currentPage(),
                'total_pages' => $categories->lastPage(),
            ]
        ]);
    }

    public function getListCategory(Request $request)
    {   
        // Ambil data dengan paginasi
        $perPage = Input::get('items', 10);
        $categories = Category::with('icon')
        ->where('published', 1)
        ->orderBy('view', 'desc')
        ->paginate($perPage);

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $categories->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $categories->total(),
                'items_per_page' => $categories->perPage(),
                'current_page' => $categories->currentPage(),
                'total_pages' => $categories->lastPage(),
            ]
        ]);
    }      
}