<?php namespace Yuren\BaliTiket\Resources;

use Backend\Classes\Controller;
use Illuminate\Support\Facades\Validator;
use Yuren\BaliTiket\Models\Bookings;
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Addon;
use Yuren\BaliTiket\Models\Rateplan;
use Firebase\JWT\JWT;
use Illuminate\Http\Request;
use Firebase\JWT\Key;

class BookingResources extends Controller
{
    private $key = "xMQsdLBGL4TInopMtedwSmLkQqYWIyWt";
    
    public function bookingHistory(Request $request)
    {
        $token = $request->bearerToken();

        if (!$token) {
            return response()->json(['error' => 'No token provided'], 401);
        }

        try {
            // Verifikasi token menggunakan Key
            $decoded = JWT::decode($token, new Key($this->key, 'HS256'));
            $payload = (array) $decoded;

            // Ambil user ID dari payload (sub biasanya digunakan untuk user ID)
            $userId = $payload['sub'] ?? null;

            if (!$userId) {
                return response()->json(['error' => 'Invalid token payload'], 401);
            }

            // Ambil data booking beserta relasi
            $bookings = Bookings::with(['ticket', 'vendor'])
                ->where('guest_id', $userId)
                ->get();

            if ($bookings->isEmpty()) {
                return response()->json([
                    'status' => 'error',
                    'message' => 'Booking Not Found.',
                ], 404);
            }

            // Format data booking
            $formattedBookings = $bookings->map(function ($booking) {
                // Proses rateplan untuk mendapatkan detail
                $rateplans = collect($booking->rateplan)->map(function ($rateplan) {
                    $details = Rateplan::select('id', 'name')->find($rateplan['rateplan_id']);
                    return [
                        'rateplan_id' => $rateplan['rateplan_id'],
                        'name' => $details->name ?? 'Unknown',
                        'price' => $rateplan['price'],
                    ];
                });

                // Proses addon untuk mendapatkan detail
                $addons = collect($booking->addon)->map(function ($addon) {
                    $details = Addon::select('id', 'name')->find($addon['addon_id']);
                    return [
                        'addon_id' => $addon['addon_id'],
                        'name' => $details->name ?? 'Unknown',
                        'type' => $addon['type'],
                        'cost' => $addon['cost'],
                    ];
                });

                return [
                    'booking' => $booking,
                    'rateplans' => $rateplans,
                    'addons' => $addons,
                ];
            });

            return response()->json([
                'status' => 'success',
                'message' => 'Booking History Found',
                'data' => $formattedBookings,
            ]);
        } catch (\Exception $e) {
            return response()->json([
                'error' => 'Unauthorized',
                'message' => $e->getMessage(),
            ], 401);
        }
    }


    public function sendForm(Request $request)
    {
        // Mengambil input dari request
        $firstname = $request->input('firstname');
        $lastname = $request->input('lastname');
        $email = $request->input('email');
        $phone = $request->input('phone');
        $country = $request->input('country');
        $terms = $request->input('terms');
        $arrival = $request->input('arrival');
        $ticketid = $request->input('ticket_id');
        $vendorid = $request->input('vendor_id');
        $vendorslug = $request->input('vendor_slug');
        $person = $request->input('person');
        $rateplan = $request->input('rateplan'); // Array
        $addon = $request->input('addon'); // Array
        $totalprice = $request->input('total_price');
        $guestid = $request->input('guest_id');

        // Data yang akan dikirimkan dalam POST request
        $postData = [
            'firstname' => $firstname,
            'lastname' => $lastname,
            'email' => $email,
            'phone' => $phone,
            'country' => $country,
            'terms' => $terms,
            'arrival' => $arrival,
            'ticket_id' => $ticketid,
            'vendor_id' => $vendorid,
            'vendor_slug' => $vendorslug,
            'person' => $person,
            'rateplan' => $rateplan, 
            'addon' => $addon, 
            'total_price' => $totalprice,
            'guest_id' => $guestid
        ];

        // Lakukan pengiriman data menggunakan curl
        $ch = curl_init('https://main.tiketxplorer.com/bali_tiket/booking_process.php');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        curl_setopt($ch, CURLOPT_POST, true);
        curl_setopt($ch, CURLOPT_POSTFIELDS, $postData);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE); // Mendapatkan status HTTP response
        $error = curl_error($ch);
        curl_close($ch);

        // Handle response dari API jika diperlukan
        if ($httpCode >= 200 && $httpCode < 300) {
            // Berhasil
            return response()->json(['message' => 'Data sent successfully', 'response' => $response]);
        } else {
            // Gagal
            return response()->json(['message' => 'Failed to send data', 'http_code' => $httpCode, 'error' => $error]);
        }
    }
}