<?php namespace Yuren\BaliTiket\Resources;

use Backend\Classes\Controller;

use Yuren\BaliTiket\Models\Category;
use Yuren\BaliTiket\Models\Blog;
use Yuren\BaliTiket\Models\Location;

use Firebase\JWT\JWT;
use Firebase\JWT\Key;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Support\Facades\Input;
use Illuminate\Support\Facades\Response;

class BlogResources extends Controller
{
    public function getHomeBlog(Request $request)
    {
        // Ambil parameter category dan items dari request
        $category = Input::get('category');
        $perPage = Input::get('items');

        // Ambil ID dari kategori berdasarkan nama
        $category_id = Category::where('name', $category)->select('id')->first();

        // Pastikan category_id ditemukan
        if ($category != null) {
            // Ambil blog yang terkait dengan kategori yang diberikan
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->whereHas('category', function($query) use ($category_id) {
                $query->where('category_id', $category_id->id);
            })
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        } else {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        }

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $blog->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $blog->total(),
                'items_per_page' => $blog->perPage(),
                'current_page' => $blog->currentPage(),
                'total_pages' => $blog->lastPage(),
            ]
        ]);
    }

    public function getHomeBlogMore(Request $request)
    {
        // Ambil parameter category dan items dari request
        $category = Input::get('category');
        $perPage = Input::get('items',10);

        // Ambil ID dari kategori berdasarkan nama
        $category_id = Category::where('name', $category)->select('id')->first();

        // Pastikan category_id ditemukan
        if ($category != null) {
            // Ambil blog yang terkait dengan kategori yang diberikan
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->whereHas('category', function($query) use ($category_id) {
                $query->where('category_id', $category_id->id);
            })
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        } else {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        }

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $blog->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $blog->total(),
                'items_per_page' => $blog->perPage(),
                'current_page' => $blog->currentPage(),
                'total_pages' => $blog->lastPage(),
            ]
        ]);
    }

    public function getDetailBlog(Request $request)
    {
        $slug = Input::get('slug');

        $blog = Blog::with(['images', 'other_img', 'location', 'category'])
        ->where('slug', $slug)
        ->first();
        

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $blog
        ]);
    }

    public function getOtherBlog(Request $request)
    {
        // Ambil parameter category dan items dari request
        $category = Input::get('category');
        $perPage = Input::get('items', 10);

        // Ambil ID dari kategori berdasarkan nama
        $category_id = Category::where('name', $category)->select('id')->first();

        // Pastikan category_id ditemukan
        if ($category != null) {
            // Ambil blog yang terkait dengan kategori yang diberikan
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->whereHas('category', function($query) use ($category_id) {
                $query->where('category_id', $category_id->id);
            })
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        } else {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        }

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $blog->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $blog->total(),
                'items_per_page' => $blog->perPage(),
                'current_page' => $blog->currentPage(),
                'total_pages' => $blog->lastPage(),
            ]
        ]);
    }

    public function getListBlog(Request $request)
    {
        // Ambil parameter category dan items dari request
        $category = Input::get('category');
        $perPage = Input::get('items', 10);

        // Ambil ID dari kategori berdasarkan nama
        $category_id = Category::where('name', $category)->select('id')->first();

        // Pastikan category_id ditemukan
        if ($category != null) {
            // Ambil blog yang terkait dengan kategori yang diberikan
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->whereHas('category', function($query) use ($category_id) {
                $query->where('category_id', $category_id->id);
            })
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        } else {
            $blog = Blog::with(['images', 'other_img', 'location', 'category'])
            ->where('published', 1)
            ->orderBy('view', 'desc')
            ->paginate($perPage);
        }

        // Format respons
        return response()->json([
            'status' => 'success',
            'message' => 'Data retrieved successfully',
            'data' => $blog->items(), // Ambil data item dari paginasi
            'meta' => [
                'total_items' => $blog->total(),
                'items_per_page' => $blog->perPage(),
                'current_page' => $blog->currentPage(),
                'total_pages' => $blog->lastPage(),
            ]
        ]);
    } 
    
    public function searchBlogLocation(Request $request)
    {
        $keyword = Input::get('keyword'); // Mendapatkan parameter keyword

        // Validasi input
        if (!$keyword) {
            return response()->json([
                'status' => 'error',
                'message' => 'Missing required parameters',
                'data' => null,
            ], 400);
        }

        // Pencarian location berdasarkan keyword pada kolom 'name'
        $locations = Location::where('name', 'LIKE', '%' . $keyword . '%')                
                        ->get();

        $blogs = Blog::where('title', 'LIKE', '%' . $keyword . '%')
                        ->orWhere('description', 'LIKE', '%' . $keyword . '%') 
                        ->orWhere('short_desc', 'LIKE', '%' . $keyword . '%')                
                        ->get();

        $data = [
            'location' => $locations,
            'blog' => $blogs
        ];

        // Kembalikan data lokasi yang ditemukan
        return response()->json([
            'status' => 'success',
            'message' => 'Locations retrieved successfully',
            'data' => $data,
        ]);
    }
}