<?php namespace Yuren\BaliTiket\Models;

use Model;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Blog;
use Yuren\BaliTiket\Models\Addon;

/**
 * Model
 */
class Ticket extends Model
{
    use \Winter\Storm\Database\Traits\Validation;
    

    /**
     * @var string The database table used by the model.
     */
    public $table = 'yuren_balitiket_tickets';

    /**
     * @var array Validation rules
     */
    public $rules = [
    ];

    protected $jsonable = ['inclusion', 'facilities', 'location', 'addons'];

    public $attachMany = [
        'images' => ['System\Models\File', 'order' => 'sort_order'],
        'other_img' => ['System\Models\File', 'order' => 'sort_order'],
    ];

    public $belongsTo = [
        'blog' => [
            'Yuren\BaliTiket\Models\Blog',
            'order' => 'title'
        ],
        'addon' => [
            'Yuren\BaliTiket\Models\Addon',
            'order' => 'name'
        ],
        'vendor' => [
            'Yuren\BaliTiket\Models\Vendor',
            'order' => 'name'
        ]
    ];


    public function priceFormat($price) {
        $price = (int)$price;
        $priceFormat = number_format($price,0,',','.');
        return $priceFormat;
    }

    public function productName($id){
        $product = Product::where('id', $id)->first();
        $name = $product->name;

        return $name;
    }

    public function blogTitle($id){
        $blog = Blog::find($id);  
        
        if ($blog) {
            return $blog->title; 
        } else {
            return 'Blog not found'; 
        }
    }
}
