<?php namespace Yuren\BaliTiket\Models;

use Model;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Ticket;

/**
 * Model
 */
class Guestlist extends Model
{
    use \Winter\Storm\Database\Traits\Validation;
    
    /*
     * Disable timestamps by default.
     * Remove this line if timestamps are defined in the database table.
     */
    public $timestamps = false;


    /**
     * @var string The database table used by the model.
     */
    public $table = 'yuren_balitiket_guestlist';

    /**
     * @var array Validation rules
     */
    public $rules = [
    ];

    public $belongsTo = [
        'vendor' => [
            'Yuren\BaliTiket\Models\Vendor',
            'order' => 'name'
        ],
        'ticket' => [
            'Yuren\BaliTiket\Models\Ticket',
            'order' => 'name'
        ]
    ];

    public function ticketName($id){
        $ticket = Ticket::where('id', $id)->first();
        $name = $ticket->name;

        return $name;
    }
}
