<?php namespace Yuren\BaliTiket\Models;

use Model;
use Yuren\BaliTiket\Models\Blog;

/**
 * Model
 */
class Category extends Model
{
    use \Winter\Storm\Database\Traits\Validation;
    

    /**
     * @var string The database table used by the model.
     */
    public $table = 'yuren_balitiket_category';

    /**
     * @var array Validation rules
     */
    public $rules = [
    ];

    public $attachOne = [
        'icon_desktop' => ['System\Models\File', 'order' => 'sort_order'],
        'icon_mobile' => ['System\Models\File', 'order' => 'sort_order'],
    ];

    public $attachMany = [
        'images' => ['System\Models\File', 'order' => 'sort_order'],
    ];

    public $belongsToMany = [
        'blog' => [
            'Yuren\BaliTiket\Models\Blog',
            'table' => 'yuren_balitiket_blog_category', 
            'order' => 'name' 
        ]
    ];
}
