<?php namespace Yuren\BaliTiket\Models;

use Model;
use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Guestlist;
use Yuren\BaliTiket\Models\Bookings;
use Yuren\BaliTiket\Models\Rateplan;
use Yuren\BaliTiket\Models\Addon;

/**
 * Model
 */
class Bookings extends Model
{
    use \Winter\Storm\Database\Traits\Validation;
    

    /**
     * @var string The database table used by the model.
     */
    public $table = 'yuren_balitiket_bookings';

    /**
     * @var array Validation rules
     */
    public $rules = [
    ];

    public $defaultSort = [
        'column' => 'created_at',
        'direction' => 'desc'
    ];

    protected $jsonable = ['rateplan','addon'];

    public $belongsTo = [
        'vendor' => [
            'Yuren\BaliTiket\Models\Vendor',
            'order' => 'name'
        ],
        'ticket' => [
            'Yuren\BaliTiket\Models\Ticket',
            'order' => 'name'
        ]
    ];

    public function priceFormat($price) {
        $price = (int)$price;
        $priceFormat = number_format($price,0,',','.');
        return $priceFormat;
    }

    public function revenueThirtyDays($vendor) {
        // Hitung tanggal 30 hari yang lalu
        $thirtyDaysAgo = now()->subDays(30)->toDateString();

        // Menghitung total harga dengan kriteria tertentu
        $totalRevenue = $this->where('status_payment', 'paid')
        ->where('invoice_date', '>=', $thirtyDaysAgo)
        ->where('vendor_id', $vendor)
        ->sum('total_price');

        // Format total revenue
        $formattedRevenue = number_format($totalRevenue, 0, ',', '.');

        return $formattedRevenue;
    }

    public function revenueToday($vendor) {
        // Tanggal hari ini
        $today = now()->toDateString();

        // Menghitung total harga dengan kriteria invoice date hari ini
        $totalRevenue = $this->where('status_payment', 'paid')
        ->where('invoice_date', '=', $today)
        ->where('vendor_id', $vendor)
        ->sum('total_price');

        // Format total revenue
        $formattedRevenue = number_format($totalRevenue, 0, ',', '.');

        return $formattedRevenue;
    }

    public function saleThirtyDays($vendor) {
        // Hitung tanggal 30 hari yang lalu
        $thirtyDaysAgo = now()->subDays(30)->toDateString();

        // Menghitung total harga dengan kriteria tertentu
        $totalSale = $this->where('status_payment', 'paid')
        ->where('invoice_date', '>=', $thirtyDaysAgo)
        ->where('vendor_id', $vendor)
        ->sum('person');

        // Format total revenue
        $formattedSale = number_format($totalSale, 0, ',', '.');

        return $formattedSale;
    }


    public function leadTime($vendor) {
        // Subquery untuk mengambil data terbaru berdasarkan invoice_date
        $subQuery = $this->select('arrival_date', 'invoice_date', 'status_payment', 'vendor_id')
            ->where('status_payment', 'paid')
            ->where('vendor_id', $vendor)
            ->orderBy('invoice_date', 'asc'); // Urutkan invoice_date dari yang paling awal
    
        // Query utama dengan logika CASE yang diperbarui
        $query = \DB::table(\DB::raw("({$subQuery->toSql()}) as sub"))
            ->selectRaw("
                CASE
                    WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 0 AND 7 THEN '0-7 days'
                    WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 8 AND 14 THEN '7-14 days'
                    WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 15 AND 30 THEN '14-30 days'
                    WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 31 AND 90 THEN '1-3 months'
                    WHEN DATEDIFF(arrival_date, invoice_date) BETWEEN 91 AND 365 THEN '3 months - 1 year'
                    ELSE 'More than 1 year'
                END AS lead_time_group,
                COUNT(*) AS total_bookings
            ")
            ->groupBy('lead_time_group')
            ->orderByRaw("
                CASE 
                    WHEN lead_time_group = '0-7 days' THEN 1
                    WHEN lead_time_group = '7-14 days' THEN 2
                    WHEN lead_time_group = '14-30 days' THEN 3
                    WHEN lead_time_group = '1-3 months' THEN 4
                    WHEN lead_time_group = '3 months - 1 year' THEN 5
                    WHEN lead_time_group = 'More than 1 year' THEN 6
                END
            ") // Mengurutkan kategori berdasarkan urutan logis
            ->mergeBindings($subQuery->getQuery()); // Menggabungkan binding dari subquery
    
        return $query->get();
    }    

    public function ticketName($id){
        $ticket = Ticket::where('id', $id)->first();
        $name = $ticket->name;

        return $name;
    }

    public function onGetTickets()
    {
        $productId = input('product_id');
        // Replace with your logic to get the tickets based on product ID
        $tickets = Ticket::where('product_id', $productId)->get();

        return [
            'tickets' => $tickets->map(function($ticket) {
                return [
                    'id' => $ticket->id,
                    'name' => $ticket->name
                ];
            })
        ];
    }

    public function personCheckin($no_invoice){
        $personCount = Guestlist::where('no_invoice', $no_invoice)->count();

        return (int)$personCount;
    }

}
