<?php namespace Yuren\BaliTiket\Models;

use Model;
use Yuren\BaliTiket\Models\Location;
use Yuren\BaliTiket\Models\Category;

/**
 * Model
 */
class Blog extends Model
{
    use \Winter\Storm\Database\Traits\Validation;
    

    /**
     * @var string The database table used by the model.
     */
    public $table = 'yuren_balitiket_blog';

    /**
     * @var array Validation rules
     */
    public $rules = [
    ];

    protected $jsonable = ['inclusion','facilities'];

    public $attachOne = [
        'images' => ['System\Models\File', 'order' => 'sort_order'],
    ];

    public $attachMany = [
        'other_img' => ['System\Models\File', 'order' => 'sort_order'],
    ];

    public $belongsTo = [
        'location' => [
            'Yuren\BaliTiket\Models\Location',
            'order' => 'name'
        ],
    ];

    public $belongsToMany = [
        'category' => [
            'Yuren\BaliTiket\Models\Category',
            'table' => 'yuren_balitiket_blog_category', 
            'order' => 'name' 
        ]
    ];

}
