<?php namespace Yuren\BaliTiket\Models;

use Model;

use Yuren\BaliTiket\Models\Vendor;
use Yuren\BaliTiket\Models\Rateplan;
use Yuren\BaliTiket\Models\Ticket;
use Yuren\BaliTiket\Models\Allocation;

/**
 * Model
 */
class Allocation extends Model
{
    use \Winter\Storm\Database\Traits\Validation;
    

    /**
     * @var string The database table used by the model.
     */
    public $table = 'yuren_balitiket_allocation';

    /**
     * @var array Validation rules
     */
    public $rules = [
    ];

    protected $jsonable = ['rateplans'];

    public $belongsTo = [
        'rateplan' => [
            'Yuren\BaliTiket\Models\Rateplan',
            'order' => 'name'
        ],
        'vendor' => [
            'Yuren\BaliTiket\Models\Vendor',
            'order' => 'name'
        ],
        'ticket' => [
            'Yuren\BaliTiket\Models\Ticket',
            'order' => 'name'
        ]
    ];

    public function checkAvailability($vendor_id, $ticket_id, $date)
    {
        $allocation = Allocation::where('vendor_id', $vendor_id)
        ->where('ticket_id', $ticket_id)
        ->whereDate('date', $date) 
        ->whereNotNull('availability')
        ->first();

        if ($allocation) {
            return $allocation->availability;
        }

        $ticket = Ticket::find($ticket_id);

        return $ticket ? $ticket->availability : null;
    }

    public function checkPrice($vendor_id, $ticket_id, $rateplan_id, $date)
    {
        $allocation = Allocation::where('vendor_id', $vendor_id)
        ->where('ticket_id', $ticket_id)
        ->whereDate('date', $date)
        ->first();

        if ($allocation && isset($allocation['rateplans'])) {
            foreach ($allocation['rateplans'] as $rateplan) {
                if ($rateplan['rateplan'] == $rateplan_id) {
                    if (!is_null($rateplan['fixed_price'])) {
                        return $rateplan['fixed_price'];
                    }
                }
            }
        }

        $rateplan = Rateplan::find($rateplan_id);

        return $rateplan ? $rateplan->fixed_price : null;
    }

    public function checkAdultPrice($vendor_id, $ticket_id, $date)
    {
        $allocation = Allocation::where('vendor_id', $vendor_id)
        ->where('ticket_id', $ticket_id)
        ->whereDate('date', $date) 
        ->whereNotNull('adult_price')
        ->first();

        if ($allocation) {
            return $allocation->adult_price;
        }

        $ticket = Ticket::find($ticket_id);

        return $ticket ? $ticket->adult_price : null;
    }

    public function checkChildrenPrice($vendor_id, $ticket_id, $date)
    {
        $allocation = Allocation::where('vendor_id', $vendor_id)
        ->where('ticket_id', $ticket_id)
        ->whereDate('date', $date) 
        ->whereNotNull('children_price')
        ->first();

        if ($allocation) {
            return $allocation->children_price;
        }

        $ticket = Ticket::find($ticket_id);

        return $ticket ? $ticket->children_price : null;
    }
}
