<?php 

namespace Yuren\BaliTiket\Middleware;

use Closure;
use Firebase\JWT\JWT;
use Firebase\JWT\Key; // Untuk mendukung perubahan pada v6.x
use Illuminate\Support\Facades\Response;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Log;

class JwtMiddleware
{
    private $key = "xMQsdLBGL4TInopMtedwSmLkQqYWIyWt"; // Kunci rahasia untuk verifikasi JWT

    public function handle(Request $request, Closure $next)
    {
        // Cek token
        $token = $request->bearerToken();

        if ($token) {
            try {
                // Verifikasi token menggunakan Key (metode baru di v6.x)
                $decoded = JWT::decode($token, new Key($this->key, 'HS256'));

                // Token valid, lanjutkan permintaan
                return $next($request);
            } catch (\Exception $e) {
                return Response::json(['error' => 'Unauthorized', 'message' => $e->getMessage()], 401);
            }
        }

        return Response::json(['error' => 'No token provided'], 401);
    }
}
