<?php namespace Yuren\BaliTiket\Controllers;

use Backend\Classes\Controller;
use BackendMenu;

class Bookings extends Controller
{
    public $implement = [        
        'Backend\Behaviors\ListController',        
        'Backend\Behaviors\FormController',        
        'Backend\Behaviors\ReorderController'    
    ];
    
    public $listConfig = 'config_list.yaml';
    public $formConfig = 'config_form.yaml';
    public $reorderConfig = 'config_reorder.yaml';

    public function __construct()
    {
        parent::__construct();
        BackendMenu::setContext('Yuren.BaliTiket', 'bali-tiket', 'booking');
    }

    public function index()
    {
        $this->addCss('/plugins/yuren/balitiket/assets/css/style.css');
        $this->addJs('/plugins/yuren/balitiket/assets/js/script.js');

        $this->asExtension('ListController')->index();
    }

    public function onViewVoucher($recordId)
    {
        $this->vars['record'] = Bookings::find($recordId);
    }

}
