<?php

return [

    /*
    |--------------------------------------------------------------------------
    | Specifies the default CMS theme
    |--------------------------------------------------------------------------
    |
    | This parameter value can be overridden by the CMS back-end settings.
    |
    */

    'activeTheme' => 'test',

    /*
    |--------------------------------------------------------------------------
    | Time to live for parsed CMS objects.
    |--------------------------------------------------------------------------
    |
    | Specifies the number of minutes the CMS object cache lives. After the interval
    | is expired item are re-cached. Note that items are re-cached automatically when
    | the corresponding template file is modified.
    |
    */

    'parsedPageCacheTTL' => 1440,

    /*
    |--------------------------------------------------------------------------
    | Determines if the routing caching is enabled.
    |--------------------------------------------------------------------------
    |
    | If the caching is enabled, the page URL map is saved in the cache. If a page
    | URL was changed on the disk, the old URL value could be still saved in the cache.
    | To update the cache the back-end Clear Cache feature should be used. It is recommended
    | to disable the caching during the development, and enable it in the production mode.
    |
    */

    'enableRoutesCache' => true,

    /*
    |--------------------------------------------------------------------------
    | Time to live for the URL map.
    |--------------------------------------------------------------------------
    |
    | The URL map used in the CMS page routing process. By default
    | the map is updated every time when a page is saved in the back-end or when the
    | interval, in minutes, specified with the urlMapCacheTTL parameter expires.
    |
    */

    'urlCacheTtl' => 1,

    /*
    |--------------------------------------------------------------------------
    | Determines if the asset caching is enabled.
    |--------------------------------------------------------------------------
    |
    | If the caching is enabled, combined assets are cached. If a asset file
    | is changed on the disk, the old file contents could be still saved in the cache.
    | To update the cache the back-end Clear Cache feature should be used. It is recommended
    | to disable the caching during the development, and enable it in the production mode.
    |
    */

    'enableAssetCache' => false,

    /*
    |--------------------------------------------------------------------------
    | Disables Twig caching for unit tests
    |--------------------------------------------------------------------------
    */

    'twigNoCache' => true,

    /*
    |--------------------------------------------------------------------------
    | Convert Line Endings
    |--------------------------------------------------------------------------
    |
    | Determines if Winter should convert line endings from the windows style
    | \r\n to the unix style \n.
    |
    */

    'convertLineEndings' => true,

    /*
    |--------------------------------------------------------------------------
    | Local plugins path
    |--------------------------------------------------------------------------
    |
    | Specifies the absolute local plugins path.
    |
    */

    'pluginsPathLocal' => base_path('modules/system/tests/fixtures/plugins'),

    /*
    |--------------------------------------------------------------------------
    | Local themes path
    |--------------------------------------------------------------------------
    |
    | Specifies the absolute local themes path.
    |
    */

    'themesPathLocal' => base_path('modules/cms/tests/fixtures/themes'),

    /*
    |--------------------------------------------------------------------------
    | Resource storage
    |--------------------------------------------------------------------------
    |
    | Specifies the configuration for resource storage, such as media and
    | upload files. These resources are used:
    |
    | media   - generated by the media manager.
    | uploads - generated by attachment model relationships.
    | resized - generated by System\Classes\ImageResizer or the resize() Twig filter
    |
    | For each resource you can specify:
    |
    | disk   - filesystem disk, as specified in filesystems.php config.
    | folder - a folder prefix for storing all generated files inside.
    | path   - the public path relative to the application base URL,
    |          or you can specify a full URL path.
    |
    | Optionally, you can specify how long temporary URLs to protected files
    | in cloud storage (ex. AWS, RackSpace) are valid for by setting
    | temporaryUrlTTL to a value in seconds to define a validity period. This
    | is only used for the 'uploads' config when using a supported cloud disk
    |
    | NOTE: If you have installed Winter in a subfolder, are using local
    | storage and are not using a linkPolicy of 'force' you should include
    | the path to the subfolder in the `path` option for these storage
    | configurations.
    |
    | Example: Winter is installed under https://localhost/projects/winter.
    | You should then specify `/projects/winter/storage/app/uploads` as the
    | path for the uploads disk and `/projects/winter/storage/app/media` as
    | the path for the media disk.
    */

    'storage' => [

        'uploads' => [
            'disk'            => 'local',
            'folder'          => 'uploads',
            'path'            => '/storage/tests/app/uploads',
            'temporaryUrlTTL' => 3600,
        ],

        'media' => [
            'disk'   => 'local',
            'folder' => 'media',
            'path'   => '/storage/tests/app/media',
        ],

        'resized' => [
            'disk'   => 'local',
            'folder' => 'resized',
            'path'   => '/storage/tests/app/resized',
        ],

    ],

    /*
    |--------------------------------------------------------------------------
    | Cross Site Request Forgery (CSRF) Protection
    |--------------------------------------------------------------------------
    |
    | If the CSRF protection is enabled, all "postback" requests are checked
    | for a valid security token.
    |
    */

    'enableCsrfProtection' => false,

];
