
<?php

error_reporting(E_ALL);
ini_set('display_errors', 1); // Menampilkan error di layar
ini_set('log_errors', 1); // Mengaktifkan logging error
ini_set('error_log', __DIR__ . '/php-error.log'); // Menentukan lokasi file log

use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
use Dompdf\Dompdf;
use Dompdf\Options;

// Include PHPMailer and Dompdf autoloaders
require 'PHPMailer/src/Exception.php';
require 'PHPMailer/src/PHPMailer.php';
require 'PHPMailer/src/SMTP.php';
require 'dompdf/autoload.inc.php'; // Adjust the path as necessary

include "phpqrcode/qrlib.php"; 

date_default_timezone_set('Asia/Makassar');

// img stored
// logo
$pathlogo = 'img/logo.png';
$datalogo = base64_encode(file_get_contents($pathlogo));
$logosrc = 'data:image/png;base64,' . $datalogo;

// envelope1
$pathenvelope1 = 'img/envelope1.png';
$dataenvelope1 = base64_encode(file_get_contents($pathenvelope1));
$envelope1src = 'data:image/png;base64,' . $dataenvelope1;

// globe1
$pathglobe1 = 'img/globe1.png';
$dataglobe1 = base64_encode(file_get_contents($pathglobe1));
$globe1src = 'data:image/png;base64,' . $dataglobe1;

// phone1
$pathphone1 = 'img/phone1.png';
$dataphone1 = base64_encode(file_get_contents($pathphone1));
$phone1src = 'data:image/png;base64,' . $dataphone1;

// barcode1
$pathbarcode1 = 'img/barcode1.png';
$databarcode1 = base64_encode(file_get_contents($pathbarcode1));
$barcode1src = 'data:image/png;base64,' . $databarcode1;

// barcode2
$pathbarcode2 = 'img/barcode2.png';
$databarcode2 = base64_encode(file_get_contents($pathbarcode2));
$barcode2src = 'data:image/png;base64,' . $databarcode2;

// ticket1
$pathticket1 = 'img/ticket1.png';
$dataticket1 = base64_encode(file_get_contents($pathticket1));
$ticket1src = 'data:image/png;base64,' . $dataticket1;

// calendar
$pathcalendar = 'img/calendar.png';
$datacalendar = base64_encode(file_get_contents($pathcalendar));
$calendarsrc = 'data:image/png;base64,' . $datacalendar;

// lockkey
$pathlockkey = 'img/lock-key.png';
$datalockkey = base64_encode(file_get_contents($pathlockkey));
$lockkeysrc = 'data:image/png;base64,' . $datalockkey;

// clock
$pathclock = 'img/clock.png';
$dataclock = base64_encode(file_get_contents($pathclock));
$clocksrc = 'data:image/png;base64,' . $dataclock;

// shield
$pathshield = 'img/shield.png';
$datashield = base64_encode(file_get_contents($pathshield));
$shieldsrc = 'data:image/png;base64,' . $datashield;

// bgfooter
$pathbgfooter = 'img/bg-footer.png';
$databgfooter = base64_encode(file_get_contents($pathbgfooter));
$bgfootersrc = 'data:image/png;base64,' . $databgfooter;

// whatsapp
$pathwhatsapp = 'img/whatsapp.png';
$datawhatsapp = base64_encode(file_get_contents($pathwhatsapp));
$whatsappsrc = 'data:image/png;base64,' . $datawhatsapp;

// envelope2
$pathenvelope2 = 'img/envelope2.png';
$dataenvelope2 = base64_encode(file_get_contents($pathenvelope2));
$envelope2src = 'data:image/png;base64,' . $dataenvelope2;

// phone2
$pathphone2 = 'img/phone2.png';
$dataphone2 = base64_encode(file_get_contents($pathphone2));
$phone2src = 'data:image/png;base64,' . $dataphone2;
// end img stored

$servername = 'localhost';
$username = 'tiketxplorer_admin';
$password = 'mindi~!@#';
$dbname = 'tiketxplorer_db';

// Mendapatkan body dari request
$body = file_get_contents("php://input");

// Decode JSON payload
$data = json_decode($body, true);

$secret_key = 'QXudHpFGdEzuVZAIFHtDwn4KDMm2ibuILpxh06x4BC2JXu0G'; // Dapatkan dari dashboard Xendit
$x_signature = isset($_SERVER['HTTP_X_CALLBACK_SIGNATURE']) ? $_SERVER['HTTP_X_CALLBACK_SIGNATURE'] : '';
$calculated_signature = hash_hmac('sha256', $body, $secret_key);

if (isset($data['status']) && $data['status'] == 'PAID') {
    // Invoice telah dibayar
    $external_id = $data['external_id'];

    $conn = new mysqli($servername, $username, $password, $dbname);

    if ($conn->connect_error) {
        http_response_code(500);
        exit('Database connection error');
    }

    $stmt = $conn->prepare("UPDATE yuren_balitiket_bookings SET status_payment='paid' WHERE no_invoice=?");
    $stmt->bind_param("s", $external_id);

    if ($stmt->execute()) {

        $sql = "SELECT * FROM yuren_balitiket_bookings WHERE no_invoice = '".$external_id."'";
        $result = $conn->query($sql);
        $booking = $result->fetch_assoc();

        $count_person = (int) $booking['person'];

        // Update availability pada tabel allocation
        $stmt2 = $conn->prepare('UPDATE yuren_balitiket_allocation SET availability = availability - ? WHERE date = ? AND vendor_id = ? AND ticket_id = ?');
        $stmt2->bind_param("isii", $count_person, $booking['arrival_date'], $booking['vendor_id'], $booking['ticket_id']);

        if ($stmt2->execute()) {

            // data booking
            $date1 = date('d/m/Y');
            $arrival_date = date('d/m/Y', strtotime($booking['arrival_date']));
            

            // get inclusion ticket
            $sqlticket = 'SELECT * FROM yuren_balitiket_tickets WHERE id = '.$booking['ticket_id'];
            $resultinclusion = $conn->query($sqlticket);
            $resultticket = $conn->query($sqlticket);
            $ticket = $resultticket->fetch_assoc();

            $inclusion_items = [];
            if ($resultinclusion->num_rows > 0) {
                while($row = $resultinclusion->fetch_assoc()) {
                    $inclusion_json = $row['inclusion'];
                    $inclusion_items = json_decode($inclusion_json, true);
                }
            }

            $inclusions = '';
            if (!empty($inclusion_items)) {
                foreach ($inclusion_items as $inclusion) {
                    $inclusions .= '<li style="margin: 0 0 7px 0">' . htmlspecialchars($inclusion['item']) . '</li>';
                }
            }
            // end get inclusion ticket

            $sqlvendor = 'SELECT * FROM yuren_balitiket_vendors WHERE id = '.$booking['vendor_id'];
            $resultvendor = $conn->query($sqlvendor);
            $vendors = $resultvendor->fetch_assoc();

            // opening hours
            $start_time = date('H:i', strtotime($ticket['start_time']));
            $end_time = date('H:i', strtotime($ticket['end_time']));

            $opening_hour = $start_time.' - '.$end_time;
            // end opening hours

            // location address
            $locationData = json_decode($ticket['location'], true);
            $address = $locationData['address'];
            // end location Address

            $total_price = number_format((int)$booking['total_price'],0,',','.');
            // end data booking

            $voucher = '';
            $voucher2 = '';
            $k = 0;

            $rateplans = json_decode($booking['rateplan'], true);
            // Mengelompokkan data berdasarkan addon_id
            $groupedRateplans = [];
            foreach ($rateplans as $rateplan) {
                $rateplanId = $rateplan['rateplan_id'];
                if (!isset($groupedRateplans[$rateplanId])) {
                    $groupedRateplans[$rateplanId] = [
                        'rateplan_id' => $rateplanId,
                        'price' => $rateplan['price'],
                        'person' => 1,
                        'subtotal' => $rateplan['price']
                    ];
                } else {
                    $groupedRateplans[$rateplanId]['person'] += 1;
                    $groupedRateplans[$rateplanId]['subtotal'] += $rateplan['price'];
                }
            }

            $addons = json_decode($booking['addon'], true);
            // Mengelompokkan data berdasarkan addon_id
            $groupedAddons = [];
            foreach ($addons as $addon) {
                $addonId = $addon['addon_id'];
                if (!isset($groupedAddons[$addonId])) {
                    $groupedAddons[$addonId] = [
                        'addon_id' => $addonId,
                        'cost' => $addon['cost'],
                        'person' => 1,
                        'subtotal' => $addon['cost']
                    ];
                } else {
                    $groupedAddons[$addonId]['person'] += 1;
                    $groupedAddons[$addonId]['subtotal'] += $addon['cost'];
                }
            }

            // Membuat tabel untuk menampilkan data
            $price_summaries = '
            <table cellspacing="0" cellpadding="5" style="width:100%; padding: 15px">
            <thead>
            <tr>
            <th style="border-bottom: 1px solid black; width: 35%; text-align: left">Name</th>
            <th style="border-bottom: 1px solid black; width: 25%; text-align: center">Price</th>
            <th style="border-bottom: 1px solid black; width: 15%; text-align: center">Person</th>
            <th style="border-bottom: 1px solid black; width: 25%; text-align: center">Subtotal</th>
            </tr>
            </thead>
            <tbody>
            ';

            foreach ($groupedRateplans as $rateplan) {
                $sqlrp = "SELECT * FROM yuren_balitiket_rateplan WHERE id = '".$rateplan['rateplan_id']."'";
                $resultrp = $conn->query($sqlrp);
                $rp = $resultrp->fetch_assoc();

                $price_summaries .= "
                <tr>
                <td style='width: 35%; text-align: left'>{$rp['name']}</td>
                <td style='width: 25%; text-align: center'>IDR " . number_format($rateplan['price'], 0, ',', '.') . "</td>
                <td style='width: 15%; text-align: center'>{$rateplan['person']}</td>
                <td style='width: 25%; text-align: center'>IDR " . number_format($rateplan['subtotal'], 0, ',', '.') . "</td>
                </tr>
                ";
            }
            
            foreach ($groupedAddons as $addon) {
                $sqlAddon = "SELECT * FROM yuren_balitiket_addon WHERE id = '".$addon['addon_id']."'";
                $resultAddon = $conn->query($sqlAddon);
                $Addon = $resultAddon->fetch_assoc();

                $price_summaries .= "
                <tr>
                <td style='width: 35%; text-align: left'>{$Addon['name']}</td>
                <td style='width: 25%; text-align: center'>IDR " . number_format($addon['cost'], 0, ',', '.') . "</td>
                <td style='width: 15%; text-align: center'>{$addon['person']}</td>
                <td style='width: 25%; text-align: center'>IDR " . number_format($addon['subtotal'], 0, ',', '.') . "</td>
                </tr>
                ";
            }

            $price_summaries .= '
            <tr>
            <td colspan="3" style="border-top: 1px solid black; text-align: right"><b>Total</b></td>
            <td style="border-top: 1px solid black; text-align: center"><b>IDR '.$total_price.'</b></td>
            </tr>
            </tbody>
            </table>
            ';


            $voucher .='
            <div style="background-color: #0A2A48; padding: 2rem; font-family: sans-serif;">
            <div style="width: 750px; margin: 0 auto; background-color: white;">
            <div style="padding: 1rem 1.5rem">

            <p style="margin: 0 0 10px 0; font-size: 12px;">'.$date1.'</p>

            <table style="width: 100%; font-size: 10px;">
            <tbody>
            <tr>
            <td style="width: 10%;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/logo.png" style="width:100%">
            </td>
            <td style="width: 80%;">
            <h4 align="center" style="margin: 0 0 7px 0; font-size: 14px;">BALI TICKET SERVICE</h4>
            <p align="center" style="margin: 0 0 7px 0;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
            <p align="center" style="margin: 0;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/envelope1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">info@tiketxplorer.com</span>
            <img src="https://main.tiketxplorer.com/bali_tiket/img/globe1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">tiketxplorer.com</span>
            <img src="https://main.tiketxplorer.com/bali_tiket/img/phone1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">(+62) 888 8888 8888</span>
            </p>
            </td>
            <td style="width: 10%;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/barcode1.png" style="width:100%">
            </td>
            </tr>
            </tbody>
            </table>

            <hr>

            <h4 style="margin: 20px 0 7px 0; font-size: 14px;">BOOKING DETAILS</h4>

            <table style="width:100%;">
            <tbody>
            <tr>
            <td style="width: 50%">
            <table style="width:100%; font-size: 12px">
            <tbody>
            <tr>
            <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Purchased Date</td>
            <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['invoice_date'].'</td>
            </tr>
            <tr>
            <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Name</td>
            <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['firstname'].'</td>
            </tr>
            </tbody>
            </table>
            </td>
            <td style="width: 50%">
            <table style="width:100%; font-size: 12px">
            <tbody>
            <tr>
            <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Ticket Validity</td>
            <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['arrival_date'].'</td>
            </tr>
            <tr>
            <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Booking ID</td>
            <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['no_invoice'].'</td>
            </tr>
            </tbody>
            </table>
            </td>
            </tr>
            </tbody>
            </table>

            <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; font-size: 11px">
            <tbody>
            <tr>
            <td style="width: 100%; padding: 0;">
            '.$price_summaries.'
            </td>
            </tr>
            </tbody>
            </table>

            <h4 style="margin: 30px 0 7px 0; font-size: 14px;">About this ticket</h4>

            <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; background-color: #ECF9FF; margin-bottom: 10rem">
            <tbody>
            <tr>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/calendar.png" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Free Cancellation</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Cancel up to 24 hours in advance for a full refund</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/lock-key.png" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Reserve now & pay later</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Keep your travel plans flexible — book your spot and pay nothing today.</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/clock.png" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Valid 1 day</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Check availability to see starting times.</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/shield.png" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Insurance</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Ensure visitor’s safety in along the trip.</p>
            </td>
            </tr>
            </tbody>
            </table>

            </div>
            <div style="padding: 1rem 1.5rem; background-image: url(https://main.tiketxplorer.com/bali_tiket/img/bg-footer.png); background-size: cover; background-position: center;">
            <table style="width: 100%; margin: 0; font-size: 12px; color: #824D0F;">
            <tbody>
            <tr>
            <td style="width: 40%; padding-right: 0.75rem; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">PT. Bali Ticket Service</p>
            <p style="font-size: 9px; margin: 0; line-height: 150%;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
            </td>
            <td style="width: 35%; padding-right: 0.75rem; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Contact Our Customer Care</p>
            <p style="font-size: 9px; margin: 0 0 7px 0;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/phone2.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
            (+62) 000 0000 0000
            </p>
            <p style="font-size: 9px; margin: 0 0 7px 0;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/whatsapp.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
            (+62) 000 0000 0000
            </p>
            <p style="font-size: 9px; margin: 0;">
            <img src="https://main.tiketxplorer.com/bali_tiket/img/envelope2.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
            test@mail.com
            </p>
            </td>
            <td style="width: 25%; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Visit Our Website</p>
            <p style="font-size: 9px; margin: 0;">Https://tiketxplorer.com</p>
            </td>
            </tr>
            </tbody>
            </table>
            </div>
            </div>
            </div>
            ';

            $voucher2 .= '<div style="padding: 1rem 1.5rem; font-family: sans-serif;">
            <header>
            <p style="margin: 0 0 10px 0; font-size: 12px;">'.$date1.'</p>

            <table style="width: 100%; font-size: 10px;">
            <tbody>
            <tr>
            <td style="width: 10%;">
            <img src="'.$logosrc.'" style="width:100%">
            </td>
            <td style="width: 80%;">
            <h4 align="center" style="margin: 0 0 7px 0; font-size: 14px;">BALI TICKET SERVICE</h4>
            <p align="center" style="margin: 0 0 7px 0;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
            <p align="center" style="margin: 0;">
            <img src="'.$envelope1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">info@tiketxplorer.com</span>
            <img src="'.$globe1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">tiketxplorer.com</span>
            <img src="'.$phone1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
            <span style="margin-right: 10px">(+62) 888 8888 8888</span>
            </p>
            </td>
            <td style="width: 10%;">
            <img src="'.$barcode1src.'" style="width:100%">
            </td>
            </tr>
            </tbody>
            </table>

            </header>

            <hr>

            <h4 style="margin: 20px 0 7px 0; font-size: 14px;">Booking Details</h4>

            <table style="width:100%;">
            <tbody>
            <tr>
            <td style="width: 50%">
            <table style="width:100%; font-size: 12px">
            <tbody>
            <tr>
            <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Purchased Date</td>
            <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['invoice_date'].'</td>
            </tr>
            <tr>
            <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Name</td>
            <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['firstname'].'</td>
            </tr>
            </tbody>
            </table>
            </td>
            <td style="width: 50%">
            <table style="width:100%; font-size: 12px">
            <tbody>
            <tr>
            <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Ticket Validity</td>
            <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['arrival_date'].'</td>
            </tr>
            <tr>
            <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Booking ID</td>
            <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['no_invoice'].'</td>
            </tr>
            </tbody>
            </table>
            </td>
            </tr>
            </tbody>
            </table>

            <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; font-size: 11px">
            <tbody>
            <tr>
            <td style="width: 100%; padding: 0;">
            '.$price_summaries.'
            </td>
            </tr>
            </tbody>
            </table>

            <h4 style="margin: 30px 0 7px 0; font-size: 14px;">About this ticket</h4>

            <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; background-color: #ECF9FF; margin-bottom:10rem">
            <tbody>
            <tr>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="'.$calendarsrc.'" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Free Cancellation</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Cancel up to 24 hours in advance for a full refund</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="'.$lockkeysrc.'" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Reserve now & pay later</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Keep your travel plans flexible — book your spot and pay nothing today.</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="'.$clocksrc.'" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Valid 1 day</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Check availability to see starting times.</p>
            </td>
            <td style="width:25%; text-align: center; padding: 1rem;">
            <img src="'.$shieldsrc.'" style="width:25px;">
            <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Insurance</p>
            <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Ensure visitor’s safety in along the trip.</p>
            </td>
            </tr>
            </tbody>
            </table>

            </div>

            <footer style="padding: 1rem 1.5rem; background-image: url('.$bgfootersrc.'); background-size: cover; background-position: center;">
            <table style="width: 100%; margin: 0; font-size: 12px; color: #824D0F;">
            <tbody>
            <tr>
            <td style="width: 40%; padding-right: 0.75rem; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">PT. Bali Ticket Service</p>
            <p style="font-size: 9px; margin: 0; line-height: 150%;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
            </td>
            <td style="width: 35%; padding-right: 0.75rem; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Contact Our Customer Care</p>
            <p style="font-size: 9px; margin: 0 0 7px 0;">
            <img src="'.$phone2src.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
            (+62) 000 0000 0000
            </p>
            <p style="font-size: 9px; margin: 0 0 7px 0;">
            <img src="'.$whatsappsrc.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
            (+62) 000 0000 0000
            </p>
            <p style="font-size: 9px; margin: 0;">
            <img src="'.$envelope2src.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
            info@tiketxplorer.com
            </p>
            </td>
            <td style="width: 25%; vertical-align: baseline;">
            <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Visit Our Website</p>
            <p style="font-size: 9px; margin: 0;">Https://tiketxplorer.com</p>
            </td>
            </tr>
            </tbody>
            </table>
            </footer>';


            foreach (json_decode($booking['rateplan'], true) as $rb){
                $sqlrb = "SELECT * FROM yuren_balitiket_rateplan WHERE id = '".$rb['rateplan_id']."'";
                $resultrb = $conn->query($sqlrb);
                $rateplan = $resultrb->fetch_assoc();

                $pathbarcode = 'barcode/'.$external_id.''.$k.'.png';
                $databarcode = base64_encode(file_get_contents($pathbarcode));
                $barcodesrc = 'data:image/png;base64,' . $databarcode;
                // end generate barcode


                // booking voucher
                $voucher .= 
                '<div style="background-color: #0A2A48; padding: 2rem; font-family: sans-serif;">
                <div style="width: 750px; margin: 0 auto; background-color: white;">
                <div style="padding: 1rem 1.5rem">

                <p style="margin: 0 0 10px 0; font-size: 12px;">'.$date1.'</p>

                <table style="width: 100%; font-size: 10px;">
                <tbody>
                <tr>
                <td style="width: 10%;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/logo.png" style="width:100%">
                </td>
                <td style="width: 80%;">
                <h4 align="center" style="margin: 0 0 7px 0; font-size: 14px;">BALI TICKET SERVICE</h4>
                <p align="center" style="margin: 0 0 7px 0;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
                <p align="center" style="margin: 0;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/envelope1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
                <span style="margin-right: 10px">info@tiketxplorer.com</span>
                <img src="https://main.tiketxplorer.com/bali_tiket/img/globe1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
                <span style="margin-right: 10px">tiketxplorer.com</span>
                <img src="https://main.tiketxplorer.com/bali_tiket/img/phone1.png" style="width:12px; margin-right:0px; vertical-align: bottom">
                <span style="margin-right: 10px">(+62) 888 8888 8888</span>
                </p>
                </td>
                <td style="width: 10%;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/barcode1.png" style="width:100%">
                </td>
                </tr>
                </tbody>
                </table>

                <hr>

                <h4 style="margin: 20px 0 7px 0; font-size: 14px;">BOOKING DETAILS</h4>

                <table style="width:100%;">
                <tbody>
                <tr>
                <td style="width: 50%">
                <table style="width:100%; font-size: 12px">
                <tbody>
                <tr>
                <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Purchased Date</td>
                <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['invoice_date'].'</td>
                </tr>
                <tr>
                <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Name</td>
                <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['firstname'].'</td>
                </tr>
                </tbody>
                </table>
                </td>
                <td style="width: 50%">
                <table style="width:100%; font-size: 12px">
                <tbody>
                <tr>
                <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Ticket Validity</td>
                <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['arrival_date'].'</td>
                </tr>
                <tr>
                <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Booking ID</td>
                <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['no_invoice'].'</td>
                </tr>
                </tbody>
                </table>
                </td>
                </tr>
                </tbody>
                </table>

                <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; font-size: 11px">
                <tbody>
                <tr>
                <td style="width: 75%; padding: 0; vertical-align: baseline; border-right: 1px dashed #008AC6;">
                <table style="font-size: 11px; width: 100%;">   
                <tr style="background-color: #ECF9FF; border-radius: 18px 0 0 0;">
                <td style="width:100%; padding:  10px; font-size:14px; color: #008AC6; border-radius: 18px 0 0 0; text-align: center">TICKET DETAILS</td>
                </tr>
                <tr>
                <td style="width:100%; padding: 1rem">
                <p style="margin: 0 0 7px 0; font-weight: 700">'.$vendors['name'].'</p>
                <p style="margin: 0 0 10px 0;">
                <span style="font-size: 14px;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/ticket1.png" style="width:18px; vertical-align: middle">
                <b>&ensp;'.$rateplan['name'].' x1</b>
                </span>
                <span style="float: right; font-size: 14px">IDR '.number_format((int)$rb['price'],0,',','.').'</span>
                </p>
                <p style="margin: 0 0 7px 0">Opening hour : '.$opening_hour.'</p>
                <p style="margin: 0 0 7px 0">Location : '.$address.'</p>
                </td>
                </tr>
                </table>
                </td>
                <td style="width: 25%; padding: 0; vertical-align: center;">
                <p style="margin: 0 0 7px 0; text-align: center">
                <img src="https://main.tiketxplorer.com/bali_tiket/'.$pathbarcode.'" style="width:60%">
                </p>
                <p style="margin: 0 0 7px 0; text-align: center">BOOKING ID :</p>
                <p style="margin: 0 0 7px 0; font-weight: bold; text-align: center;">'.$booking['no_invoice'].'</p>
                </td>
                </tr>
                </tbody>
                </table>

                <h4 style="margin: 30px 0 7px 0; font-size: 14px;">About this ticket</h4>

                <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; background-color: #ECF9FF">
                <tbody>
                <tr>
                <td style="width:25%; text-align: center; padding: 1rem;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/calendar.png" style="width:25px;">
                <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Free Cancellation</p>
                <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Cancel up to 24 hours in advance for a full refund</p>
                </td>
                <td style="width:25%; text-align: center; padding: 1rem;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/lock-key.png" style="width:25px;">
                <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Reserve now & pay later</p>
                <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Keep your travel plans flexible — book your spot and pay nothing today.</p>
                </td>
                <td style="width:25%; text-align: center; padding: 1rem;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/clock.png" style="width:25px;">
                <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Valid 1 day</p>
                <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Check availability to see starting times.</p>
                </td>
                <td style="width:25%; text-align: center; padding: 1rem;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/shield.png" style="width:25px;">
                <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Insurance</p>
                <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Ensure visitor’s safety in along the trip.</p>
                </td>
                </tr>
                </tbody>
                </table>

                <table style="width: 100%; margin: 30px 0 50px 0; font-size: 12px">
                <tbody>
                <tr>
                <td style="width: 40%">
                <p style="margin: 0 0 4px 0"><b>Ticket inclusions : </b></p>
                <ul style="padding: 0 0 0 1rem; margin: 7px 0 0 0;">
                '.$inclusions.'
                </ul>
                </td>
                <td style="width: 60%; vertical-align: baseline;">
                <p style="margin: 0 0 7px 0"><b>Terms & Conditions : </b></p>
                '.$ticket['terms'].'
                </td>
                </tr>
                </tbody>
                </table>

                </div>
                <div style="padding: 1rem 1.5rem; background-image: url(https://main.tiketxplorer.com/bali_tiket/img/bg-footer.png); background-size: cover; background-position: center;">
                <table style="width: 100%; margin: 0; font-size: 12px; color: #824D0F;">
                <tbody>
                <tr>
                <td style="width: 40%; padding-right: 0.75rem; vertical-align: baseline;">
                <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">PT. Bali Ticket Service</p>
                <p style="font-size: 9px; margin: 0; line-height: 150%;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
                </td>
                <td style="width: 35%; padding-right: 0.75rem; vertical-align: baseline;">
                <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Contact Our Customer Care</p>
                <p style="font-size: 9px; margin: 0 0 7px 0;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/phone2.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
                (+62) 000 0000 0000
                </p>
                <p style="font-size: 9px; margin: 0 0 7px 0;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/whatsapp.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
                (+62) 000 0000 0000
                </p>
                <p style="font-size: 9px; margin: 0;">
                <img src="https://main.tiketxplorer.com/bali_tiket/img/envelope2.png" style="width:11px; vertical-align:bottom; margin-right: 3px">
                test@mail.com
                </p>
                </td>
                <td style="width: 25%; vertical-align: baseline;">
                <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Visit Our Website</p>
                <p style="font-size: 9px; margin: 0;">Https://tiketxplorer.com</p>
                </td>
                </tr>
                </tbody>
                </table>
                </div>
                </div>
                </div>';

                if ($k >= 0) {
                    $voucher2 .= '<div style="page-break-before: always;"></div>';
                }

                $voucher2 .= '<div style="padding: 1rem 1.5rem; font-family: sans-serif;">
                <header>
                <p style="margin: 0 0 10px 0; font-size: 12px;">'.$date1.'</p>

                <table style="width: 100%; font-size: 10px;">
                <tbody>
                <tr>
                <td style="width: 10%;">
                <img src="'.$logosrc.'" style="width:100%">
                </td>
                <td style="width: 80%;">
                <h4 align="center" style="margin: 0 0 7px 0; font-size: 14px;">BALI TICKET SERVICE</h4>
                <p align="center" style="margin: 0 0 7px 0;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
                <p align="center" style="margin: 0;">
                <img src="'.$envelope1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
                <span style="margin-right: 10px">info@tiketxplorer.com</span>
                <img src="'.$globe1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
                <span style="margin-right: 10px">tiketxplorer.com</span>
                <img src="'.$phone1src.'" style="width:12px; margin-right:0px; vertical-align: bottom">
                <span style="margin-right: 10px">(+62) 888 8888 8888</span>
                </p>
                </td>
                <td style="width: 10%;">
                <img src="'.$barcode1src.'" style="width:100%">
                </td>
                </tr>
                </tbody>
                </table>

                </header>

                <hr>

                <h4 style="margin: 20px 0 7px 0; font-size: 14px;">Booking Details</h4>

                <table style="width:100%;">
                <tbody>
                <tr>
                <td style="width: 50%">
                <table style="width:100%; font-size: 12px">
                <tbody>
                <tr>
                <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Purchased Date</td>
                <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['invoice_date'].'</td>
                </tr>
                <tr>
                <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Name</td>
                <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['firstname'].'</td>
                </tr>
                </tbody>
                </table>
                </td>
                <td style="width: 50%">
                <table style="width:100%; font-size: 12px">
                <tbody>
                <tr>
                <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Ticket Validity</td>
                <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['arrival_date'].'</td>
                </tr>
                <tr>
                <td style="width: 30%; padding: 0 0 7px 0; font-weight: bold;">Booking ID</td>
                <td style="width: 70%; padding: 0 0 7px 0;">: '.$booking['no_invoice'].'</td>
                </tr>
                </tbody>
                </table>
                </td>
                </tr>
                </tbody>
                </table>

                <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; font-size: 11px">
                <tbody>
                <tr>
                <td style="width: 75%; padding: 0; vertical-align: baseline; border-right: 1px dashed #008AC6;">
                <table style="font-size: 11px; width: 100%;">   
                <tr style="background-color: #ECF9FF; border-radius: 18px 0 0 0;">
                <td style="width:100%; padding:  10px; font-size:14px; color: #008AC6; border-radius: 18px 0 0 0; text-align: center">TICKET DETAILS</td>
                </tr>
                <tr>
                <td style="width:100%; padding: 1rem">
                <p style="margin: 0 0 7px 0; font-weight: 700">'.$vendors['name'].'</p>
                <p style="margin: 0 0 10px 0;">
                <span style="font-size: 14px;">
                <img src="'.$ticket1src.'" style="width:18px; vertical-align: middle">
                <b>&ensp;'.$rateplan['name'].' x1 </b>
                </span>
                <span style="float: right; font-size: 14px">IDR '.number_format((int)$rb['price'],0,',','.').'</span>
                </p>
                <p style="margin: 0 0 7px 0">Opening hour : '.$opening_hour.'</p>
                <p style="margin: 0 0 7px 0">Location : '.$address.'</p>
                </td>
                </tr>
                </table>
                </td>
                <td style="width: 25%; padding: 0; vertical-align: center;">
                <p style="margin: 0 0 7px 0; text-align: center">
                <img src="'.$barcodesrc.'" style="width:60%">
                </p>
                <p style="margin: 0 0 7px 0; text-align: center">BOOKING ID :</p>
                <p style="margin: 0 0 7px 0; font-weight: bold; text-align: center;">'.$booking['no_invoice'].'</p>
                </td>
                </tr>
                </tbody>
                </table>

                <h4 style="margin: 30px 0 7px 0; font-size: 14px;">About this ticket</h4>

                <table style="width:100%; border:1px solid #008AC6; border-radius: 20px; background-color: #ECF9FF">
                <tbody>
                <tr>
                <td style="width:25%; text-align: center; padding: 1rem;">
                <img src="'.$calendarsrc.'" style="width:25px;">
                <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Free Cancellation</p>
                <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Cancel up to 24 hours in advance for a full refund</p>
                </td>
                <td style="width:25%; text-align: center; padding: 1rem;">
                <img src="'.$lockkeysrc.'" style="width:25px;">
                <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Reserve now & pay later</p>
                <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Keep your travel plans flexible — book your spot and pay nothing today.</p>
                </td>
                <td style="width:25%; text-align: center; padding: 1rem;">
                <img src="'.$clocksrc.'" style="width:25px;">
                <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Valid 1 day</p>
                <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Check availability to see starting times.</p>
                </td>
                <td style="width:25%; text-align: center; padding: 1rem;">
                <img src="'.$shieldsrc.'" style="width:25px;">
                <p align="center" style="font-size:12px; margin: 5px 0 5px 0 ;font-weight: 600;">Insurance</p>
                <p align="center" style="font-size:9px; color: darkgrey; margin: 0">Ensure visitor’s safety in along the trip.</p>
                </td>
                </tr>
                </tbody>
                </table>

                <table style="width: 100%; margin: 30px 0 50px 0; font-size: 12px">
                <tbody>
                <tr>
                <td style="width: 40%">
                <p style="margin: 0 0 4px 0"><b>Ticket inclusions : </b></p>
                <ul style="padding: 0 0 0 1rem; margin: 7px 0 0 0;">
                '.$inclusions.'
                </ul>
                </td>
                <td style="width: 60%; vertical-align: baseline;">
                <p style="margin: 0 0 7px 0"><b>Terms & Conditions : </b></p>
                '.$ticket['terms'].'
                </td>
                </tr>
                </tbody>
                </table>

                </div>
                <footer style="padding: 1rem 1.5rem; background-image: url('.$bgfootersrc.'); background-size: cover; background-position: center;">
                <table style="width: 100%; margin: 0; font-size: 12px; color: #824D0F;">
                <tbody>
                <tr>
                <td style="width: 40%; padding-right: 0.75rem; vertical-align: baseline;">
                <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">PT. Bali Ticket Service</p>
                <p style="font-size: 9px; margin: 0; line-height: 150%;">Regus Benoa Square, Jl. Bypass Ngurah Rai No. 21A, Badung Regency, Bali</p>
                </td>
                <td style="width: 35%; padding-right: 0.75rem; vertical-align: baseline;">
                <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Contact Our Customer Care</p>
                <p style="font-size: 9px; margin: 0 0 7px 0;">
                <img src="'.$phone2src.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
                (+62) 000 0000 0000
                </p>
                <p style="font-size: 9px; margin: 0 0 7px 0;">
                <img src="'.$whatsappsrc.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
                (+62) 000 0000 0000
                </p>
                <p style="font-size: 9px; margin: 0;">
                <img src="'.$envelope2src.'" style="width:11px; vertical-align:bottom; margin-right: 3px">
                info@tiketxplorer.com
                </p>
                </td>
                <td style="width: 25%; vertical-align: baseline;">
                <p style="font-size: 14px; font-weight: 600; margin: 0 0 10px 0;">Visit Our Website</p>
                <p style="font-size: 9px; margin: 0;">Https://tiketxplorer.com</p>
                </td>
                </tr>
                </tbody>
                </table>
                </footer>';

                $k = $k + 1;
            }



            // Generate PDF from HTML content
            $options = new Options();
            $options->set('isHtml5ParserEnabled', true); 
            $options->set('isPhpEnabled', true); 

            $dompdf = new Dompdf($options);
            $dompdf->loadHtml($voucher2);

            // Set paper size and orientation (optional)
            $dompdf->setPaper('A4', 'portrait');

            // Render PDF (optional)
            $dompdf->render();

            // Save PDF file
            $pdfFilePath = 'voucher/' . $booking['no_invoice'] . '.pdf';
            file_put_contents($pdfFilePath, $dompdf->output());

            // Update database with PDF file path
            $stmtUpdate = $conn->prepare("UPDATE yuren_balitiket_bookings SET voucher_link=? WHERE no_invoice=?");
            $stmtUpdate->bind_param("ss", $pdfFilePath, $external_id);
            $stmtUpdate->execute();
            // end booking voucher

            // send voucher
            try {
                $mail = new PHPMailer(true);

                //Server settings
                $mail->SMTPDebug = 0;  
                $mail->Host       = 'mail.mindimedia.com';                 
                $mail->SMTPAuth   = true;                                
                $mail->Username   = 'rendi@mindimedia.com';        
                $mail->Password   = 'RendiMindi2023';                            
                $mail->SMTPSecure = 'ssl';       
                $mail->Port       = 465;

                //pengirim
                $mail->setFrom('rendi@mindimedia.com', 'Bali Ticket Services');
                $mail->addAddress($booking['email']);

                //Content
                $mail->isHTML(true);
                $mail->Subject = 'Ticket - '.$booking['no_invoice'];
                $mail->Body    = $voucher;

                $mail->addAttachment($pdfFilePath);

                $mail->AltBody = '';
                $mail->send();

            } catch (Exception $e){

            } 
        // end send voucher
        }

    } else {
        file_put_contents('xendit-webhook.log', "Query error: " . $stmt->error . "\n", FILE_APPEND);
        http_response_code(500);
        exit('Database query error');
    }

    $stmt->close();
    $conn->close();
    
} elseif (isset($data['status']) && $data['status'] == 'EXPIRED') {

    $external_id = $data['external_id'];

    $sql4 = "SELECT * FROM yuren_balitiket_bookings WHERE no_invoice = '".$external_id."'";
    $result4 = $conn->query($sql4);
    $booking = $result4->fetch_assoc();

    $sql5 = "SELECT * FROM yuren_balitiket_tickets WHERE id = '".$booking['ticket_id']."'";
    $result5 = $conn->query($sql5);
    $ticket = $result5->fetch_assoc();

    $link_payment = "https://main.tiketxplorer.com/bali_tiket/payment.php?no_invoice=".$booking['no_invoice'];

    $email_text = 
    '
    <div style="background-color: #0A2A48; padding: 2rem; font-family: sans-serif; font-size:13px">

    <div style="padding: 2rem; background-color: white; width: 750px; margin: 0 auto">

    <p><b>Dear '.$booking['firstname'].',</b></p>

    <p style="margin-bottom: 5px;">This is a reminder that your booking with Bali Tiket is about to expire. Please complete your payment to secure your booking.</p>

    <p style="margin:0 0 8px 0;">Here are the details of your booking:</p>

    <table style="width: 100%; border:1px solid grey; padding: 1rem; font-size: 13px;">
    <tbody>
    <tr>
    <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Name</td>
    <td style="padding-bottom: 8px;width: 75%;">: '.$booking['firstname'].'</td>
    </tr>
    <tr>
    <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Phone Number</td>
    <td style="padding-bottom: 8px;width: 75%;">: '.$booking['phone'].'</td>
    </tr>
    <tr>
    <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Email</td>
    <td style="padding-bottom: 8px;width: 75%;">: '.$booking['email'].'</td>
    </tr>
    <tr>
    <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Ticket</td>
    <td style="padding-bottom: 8px;width: 75%;">: '.$ticket['name'].'</td>
    </tr>
    <tr>
    <td style="padding-bottom: 8px;width: 25%; font-weight: bold;">Person</td>
    <td style="padding-bottom: 8px;width: 75%;">: '.$booking['person'].' Person</td>
    </tr>
    <tr>
    <td style="width: 25%; font-weight: bold;">Total Price</td>
    <td style="width: 75%;">: IDR '.number_format((int)$booking['total_price'],0,',','.').'</td>
    </tr>
    </tbody>
    </table>

    <p>To complete the booking process, please click the button below to make the payment:</p>

    <p align="center" style="margin: 20px 0;"><a href="'.$link_payment.'" target="_blank" style="background-color: #0A2A48; padding: 7px 30px; border-radius: 3px; color: white; text-decoration: none; font-weight: bold; text-transform: uppercase;">Click Here to Pay</a></p>

    <p>If you have any questions or need further assistance, please feel free to contact us.</p>

    <p>Thank you and have a great day!</p>

    <p style="margin-bottom: 30px;">Best regards,</p>

    <p style="margin-bottom: 5px"><b>Bali Ticket Services</b></p>
    <p style="margin-top: 0px">(+62) 00 0000 0000</p>

    </div>

    </div>
    ';

    // send email
    try {
        $mail = new PHPMailer(true);

        //Server settings
        $mail->SMTPDebug = 0;  
        $mail->Host       = 'mail.mindimedia.com';                 
        $mail->SMTPAuth   = true;                                
        $mail->Username   = 'rendi@mindimedia.com';        
        $mail->Password   = 'RendiMindi2023';                            
        $mail->SMTPSecure = 'ssl';       
        $mail->Port       = 465;

        //pengirim
        $mail->setFrom('rendi@mindimedia.com', 'Bali Ticket Services');
        $mail->addAddress($booking['email']);

        //Content
        $mail->isHTML(true);
        $mail->Subject = 'Booking Reminder - '.$booking['no_invoice'];
        $mail->Body    = $email_text;

        $mail->AltBody = '';
        $mail->send();

    } catch (Exception $e){

    } 

} else {
    file_put_contents('xendit-webhook.log', "Invalid status\n", FILE_APPEND);
    http_response_code(400);
    exit('Invalid status');
}

// Response ke Xendit bahwa webhook telah diterima dan diproses
http_response_code(200);
echo 'Webhook received';
?>
